/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.codecs;

import org.codehaus.groovy.grails.plugins.codecs.AbstractCharReplacementEncoder;
import org.codehaus.groovy.grails.support.encoding.CodecIdentifier;
import org.codehaus.groovy.grails.support.encoding.DefaultCodecIdentifier;

public class JavaScriptEncoder
extends AbstractCharReplacementEncoder {
    public static final CodecIdentifier JAVASCRIPT_CODEC_IDENTIFIER = new DefaultCodecIdentifier("JavaScript", new String[]{"JSON", "Json", "Js"});

    public JavaScriptEncoder() {
        super(JAVASCRIPT_CODEC_IDENTIFIER);
    }

    protected String escapeCharacter(char ch, char previousChar) {
        switch (ch) {
            case '\"': {
                return "\\u0022";
            }
            case '\'': {
                return "\\u0027";
            }
            case '\\': {
                return "\\u005c";
            }
            case '/': {
                return "\\u002f";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                if (previousChar != '\r') {
                    return "\\n";
                }
            }
            case '\r': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '&': {
                return "\\u0026";
            }
            case '<': {
                return "\\u003c";
            }
            case '>': {
                return "\\u003e";
            }
            case '(': {
                return "\\u0028";
            }
            case ')': {
                return "\\u0029";
            }
            case '[': {
                return "\\u005b";
            }
            case ']': {
                return "\\u005d";
            }
            case '{': {
                return "\\u007b";
            }
            case '}': {
                return "\\u007d";
            }
            case ',': {
                return "\\u002c";
            }
            case ';': {
                return "\\u003b";
            }
            case '@': {
                return "\\u0040";
            }
        }
        return null;
    }

    public boolean isApplyToSafelyEncoded() {
        return true;
    }
}

