/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.simple;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.grails.datastore.mapping.core.AbstractDatastore;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.keyvalue.mapping.config.KeyValueMappingContext;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.simple.SimpleMapSession;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SimpleMapDatastore
extends AbstractDatastore {
    private Map<String, Map> datastore = new ConcurrentHashMap<String, Map>();
    private Map indices = new ConcurrentHashMap();

    public SimpleMapDatastore(Map<String, Map> datastore, ConfigurableApplicationContext ctx) {
        this();
        this.datastore = datastore;
        this.setApplicationContext((ApplicationContext)ctx);
    }

    public SimpleMapDatastore(MappingContext mappingContext, ConfigurableApplicationContext ctx) {
        super(mappingContext, null, ctx);
        this.initializeConverters(this.getMappingContext());
    }

    public SimpleMapDatastore() {
        this(null);
    }

    public SimpleMapDatastore(ConfigurableApplicationContext ctx) {
        this((MappingContext)new KeyValueMappingContext(""), ctx);
    }

    public Map getIndices() {
        return this.indices;
    }

    protected Session createSession(Map<String, String> connectionDetails) {
        return new SimpleMapSession(this, this.getMappingContext(), this.getApplicationEventPublisher());
    }

    public Map<String, Map> getBackingMap() {
        return this.datastore;
    }

    public void clearData() {
        this.datastore.clear();
        this.indices.clear();
    }
}

