/*
 * Decompiled with CFR 0.152.
 */
package grails.io;

import grails.util.BuildSettings;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.io.support.SpringIOUtils;
import org.grails.io.support.UrlResource;

public class IOUtils
extends SpringIOUtils
implements GroovyObject {
    private static String applicationDirectory;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public IOUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static BufferedInputStream openStream(File file) {
        if (!file.exists()) {
            throw (Throwable)new FileNotFoundException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{file}, new String[]{"File ", " does not exist"})));
        }
        if (file.isDirectory()) {
            throw (Throwable)new IOException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{file}, new String[]{"File ", " exists but is a directory"})));
        }
        if (!file.canRead()) {
            throw (Throwable)new IOException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{file}, new String[]{"File ", " cannot be read"})));
        }
        return ResourceGroovyMethods.newInputStream((File)file);
    }

    public static String toString(Reader reader) {
        StringWriter writer = new StringWriter();
        SpringIOUtils.copy(reader, (Writer)writer);
        return writer.toString();
    }

    public static String toString(InputStream stream, String encoding) {
        StringWriter writer = new StringWriter();
        IOUtils.copy(stream, writer, encoding);
        return writer.toString();
    }

    public static void copy(InputStream input, Writer output, String encoding) {
        InputStreamReader reader = DefaultTypeTransformation.booleanUnbox((Object)encoding) ? new InputStreamReader(input, encoding) : new InputStreamReader(input);
        SpringIOUtils.copy(reader, output);
    }

    public static File findJarFile(Class targetClass) {
        URL uRL = IOUtils.findClassResource(targetClass);
        String absolutePath = uRL != null ? uRL.getPath() : null;
        if (DefaultTypeTransformation.booleanUnbox((Object)absolutePath)) {
            String jarPath = absolutePath.substring("file:".length(), absolutePath.lastIndexOf("!"));
            return new File(jarPath);
        }
        return (File)ScriptBytecodeAdapter.castToType(null, File.class);
    }

    public static URL findClassResource(Class targetClass) {
        return targetClass.getResource(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"/", (CharSequence)targetClass.getName().replace(".", "/")), (CharSequence)".class"));
    }

    public static URL findResourceRelativeToClass(Class targetClass, String path) {
        String pathToClassFile = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"/", (CharSequence)targetClass.getName().replace(".", "/")), (CharSequence)".class");
        URL classRes = targetClass.getResource(pathToClassFile);
        if (classRes != null) {
            String rootPath = StringGroovyMethods.minus((CharSequence)classRes.toString(), (Object)pathToClassFile);
            if (rootPath.endsWith(BuildSettings.BUILD_CLASSES_PATH)) {
                String string;
                rootPath = string = rootPath.replace("/build/classes/", "/build/resources/");
            }
            return new URL(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{rootPath, path}, new String[]{"", "", ""})));
        }
        return (URL)ScriptBytecodeAdapter.castToType(null, URL.class);
    }

    public static File findApplicationDirectoryFile() {
        String directory = IOUtils.findApplicationDirectory();
        if (DefaultTypeTransformation.booleanUnbox((Object)directory)) {
            File f = new File(directory);
            if (f.exists()) {
                return f;
            }
        }
        return (File)ScriptBytecodeAdapter.castToType(null, File.class);
    }

    public static String findApplicationDirectory() {
        String string;
        if (DefaultTypeTransformation.booleanUnbox((Object)applicationDirectory)) {
            return applicationDirectory;
        }
        String location = null;
        try {
            String mainClassName = System.getProperty(BuildSettings.MAIN_CLASS_NAME);
            if (!DefaultTypeTransformation.booleanUnbox((Object)mainClassName)) {
                Object[] stackTraceElements = Thread.currentThread().getStackTrace();
                if (DefaultTypeTransformation.booleanUnbox((Object)stackTraceElements)) {
                    StackTraceElement lastElement = (StackTraceElement)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])stackTraceElements, (int)-1), StackTraceElement.class);
                    String className = lastElement.getClassName();
                    String methodName = lastElement.getMethodName();
                    if (className.endsWith(".Application") && ScriptBytecodeAdapter.compareEqual((Object)methodName, (Object)"<clinit>")) {
                        String string2;
                        mainClassName = string2 = className;
                    }
                }
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)mainClassName)) {
                Class<?> mainClass = Thread.currentThread().getContextClassLoader().loadClass(mainClassName);
                URL classResource = (URL)ScriptBytecodeAdapter.castToType((Object)(mainClass != null ? IOUtils.findClassResource(mainClass) : null), URL.class);
                if (classResource != null) {
                    File file = new UrlResource(classResource).getFile();
                    String path = file.getCanonicalPath();
                    if (path.contains(BuildSettings.BUILD_CLASSES_PATH)) {
                        String string3;
                        location = string3 = path.substring(0, path.indexOf(BuildSettings.BUILD_CLASSES_PATH) - 1);
                    }
                }
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (IOException e) {
        }
        applicationDirectory = string = location;
        return location;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != IOUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static String toString(InputStream stream) {
        return IOUtils.toString(stream, null);
    }

    public static void copy(InputStream input, Writer output) {
        IOUtils.copy(input, output, null);
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }
}

