/*
 * Decompiled with CFR 0.152.
 */
package org.grails.io.support;

import grails.util.Environment;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.grails.io.support.ByteArrayResource;
import org.grails.io.support.FileSystemResourceLoader;
import org.grails.io.support.PathMatchingResourcePatternResolver;
import org.grails.io.support.Resource;
import org.grails.io.support.ResourceLoader;

public class ResourceLocator {
    public static final String WILDCARD = "*";
    public static final String FILE_SEPARATOR = File.separator;
    public static final String CLOSURE_MARKER = "$";
    public static final String WEB_APP_DIR = "web-app";
    protected static final Resource NULL_RESOURCE = new ByteArrayResource("null".getBytes());
    protected PathMatchingResourcePatternResolver patchMatchingResolver;
    protected List<String> classSearchDirectories = new ArrayList<String>();
    protected List<String> resourceSearchDirectories = new ArrayList<String>();
    protected Map<String, Resource> classNameToResourceCache = new ConcurrentHashMap<String, Resource>();
    protected Map<String, Resource> uriToResourceCache = new ConcurrentHashMap<String, Resource>();
    protected ResourceLoader defaultResourceLoader = new FileSystemResourceLoader();
    protected boolean warDeployed = Environment.isWarDeployed();

    public void setSearchLocation(String searchLocation) {
        ResourceLoader resourceLoader = this.getDefaultResourceLoader();
        this.patchMatchingResolver = new PathMatchingResourcePatternResolver(resourceLoader);
        this.initializeForSearchLocation(searchLocation);
    }

    protected ResourceLoader getDefaultResourceLoader() {
        return this.defaultResourceLoader;
    }

    public void setSearchLocations(Collection<String> searchLocations) {
        this.patchMatchingResolver = new PathMatchingResourcePatternResolver(this.getDefaultResourceLoader());
        for (String searchLocation : searchLocations) {
            this.initializeForSearchLocation(searchLocation);
        }
    }

    private void initializeForSearchLocation(String searchLocation) {
        String searchLocationPlusSlash = searchLocation.endsWith("/") ? searchLocation : searchLocation + FILE_SEPARATOR;
        try {
            File[] directories = new File(searchLocationPlusSlash + "grails-app").listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() && !file.isHidden();
                }
            });
            if (directories != null) {
                for (File directory : directories) {
                    this.classSearchDirectories.add(directory.getCanonicalPath());
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.classSearchDirectories.add(searchLocationPlusSlash + "src/main/java");
        this.classSearchDirectories.add(searchLocationPlusSlash + "src/main/groovy");
        this.resourceSearchDirectories.add(searchLocationPlusSlash);
    }

    public Resource findResourceForURI(String uri) {
        Resource resource = this.uriToResourceCache.get(uri);
        if (resource == null) {
            PluginResourceInfo info = this.inferPluginNameFromURI(uri);
            if (this.warDeployed) {
                Resource defaultResource = this.defaultResourceLoader.getResource(uri);
                if (defaultResource != null && defaultResource.exists()) {
                    resource = defaultResource;
                }
            } else {
                String uriWebAppRelative = WEB_APP_DIR + uri;
                for (String resourceSearchDirectory : this.resourceSearchDirectories) {
                    Resource pluginFile;
                    String filename;
                    Resource dir;
                    Resource res = this.resolveExceptionSafe(resourceSearchDirectory + uriWebAppRelative);
                    if (res.exists()) {
                        resource = res;
                        continue;
                    }
                    if (this.warDeployed || !(dir = this.resolveExceptionSafe(resourceSearchDirectory)).exists() || info == null || (filename = dir.getFilename()) == null || !filename.equals(info.pluginName) || !(pluginFile = dir.createRelative(WEB_APP_DIR + info.uri)).exists()) continue;
                    resource = pluginFile;
                }
            }
            if (resource == null || !resource.exists()) {
                Resource tmp;
                Resource resource2 = tmp = this.defaultResourceLoader != null ? this.defaultResourceLoader.getResource(uri) : null;
                if (tmp != null && tmp.exists()) {
                    resource = tmp;
                }
            }
            if (resource != null) {
                this.uriToResourceCache.put(uri, resource);
            } else if (this.warDeployed) {
                this.uriToResourceCache.put(uri, NULL_RESOURCE);
            }
        }
        return resource == NULL_RESOURCE ? null : resource;
    }

    private PluginResourceInfo inferPluginNameFromURI(String uri) {
        String withoutPluginsPath;
        int i;
        if (uri.startsWith("/plugins/") && (i = (withoutPluginsPath = uri.substring("/plugins/".length(), uri.length())).indexOf(47)) > -1) {
            PluginResourceInfo info = new PluginResourceInfo();
            info.pluginName = withoutPluginsPath.substring(0, i);
            info.uri = withoutPluginsPath.substring(i, withoutPluginsPath.length());
            return info;
        }
        return null;
    }

    public Resource findResourceForClassName(String className) {
        Resource resource;
        if (className.contains(CLOSURE_MARKER)) {
            className = className.substring(0, className.indexOf(CLOSURE_MARKER));
        }
        if ((resource = this.classNameToResourceCache.get(className)) == null) {
            String classNameWithPathSeparator = className.replace(".", FILE_SEPARATOR);
            for (String pathPattern : this.getSearchPatternForExtension(classNameWithPathSeparator, ".groovy", ".java")) {
                resource = this.resolveExceptionSafe(pathPattern);
                if (resource == null || !resource.exists()) continue;
                this.classNameToResourceCache.put(className, resource);
                break;
            }
        }
        return resource != null && resource.exists() ? resource : null;
    }

    private List<String> getSearchPatternForExtension(String classNameWithPathSeparator, String ... extensions) {
        ArrayList<String> searchPatterns = new ArrayList<String>();
        for (String extension : extensions) {
            String filename = classNameWithPathSeparator + extension;
            for (String classSearchDirectory : this.classSearchDirectories) {
                searchPatterns.add(classSearchDirectory + FILE_SEPARATOR + filename);
            }
        }
        return searchPatterns;
    }

    private Resource resolveExceptionSafe(String pathPattern) {
        try {
            Resource[] resources = this.patchMatchingResolver.getResources("file:" + pathPattern);
            if (resources != null && resources.length > 0) {
                return resources[0];
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.defaultResourceLoader = resourceLoader;
    }

    class PluginResourceInfo {
        String pluginName;
        String uri;

        PluginResourceInfo() {
        }
    }
}

