/*
 * Decompiled with CFR 0.152.
 */
package grails.build.logging;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jline.ConsoleReader;
import jline.Terminal;
import jline.WindowsTerminal;

public final class PatchedJLineWindowsTerminal
extends WindowsTerminal {
    private static final int ENABLE_PROCESSED_INPUT = 1;
    private static final int ENABLE_WINDOW_INPUT = 8;
    private final ConsoleReader reader;

    public PatchedJLineWindowsTerminal(ConsoleReader reader) {
        this.reader = reader;
    }

    public static Terminal setupTerminal(ConsoleReader reader) throws Exception {
        PatchedJLineWindowsTerminal terminal = new PatchedJLineWindowsTerminal(reader);
        terminal.initializeTerminal();
        return terminal;
    }

    public void initializeTerminal() throws Exception {
        super.initializeTerminal();
        this.setConsoleModeHacked(this.getConsoleModeHacked() | 1 | 8);
        this.fixCtrlC(this.reader);
    }

    public boolean isANSISupported() {
        return true;
    }

    private Integer getConsoleModeHacked() {
        return (Integer)this.invokePrivateMethod(WindowsTerminal.class, (Object)this, "getConsoleMode", null);
    }

    private void setConsoleModeHacked(Integer mode) {
        this.invokePrivateMethod(WindowsTerminal.class, (Object)this, "setConsoleMode", new Object[]{mode});
    }

    private void fixCtrlC(ConsoleReader reader) {
        if (reader == null) {
            return;
        }
        try {
            Field f = ConsoleReader.class.getDeclaredField("keybindings");
            f.setAccessible(true);
            short[] keybindings = (short[])f.get(reader);
            if (keybindings[3] == -48) {
                keybindings[3] = 3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        reader.addTriggeredAction('\u0003', new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
    }

    private Object invokePrivateMethod(Class<?> clazz, Object o, String methodName, Object[] params) {
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methodName.equals(methods[i].getName())) continue;
            try {
                methods[i].setAccessible(true);
                return methods[i].invoke(o, params);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("IllegalAccessException accessing " + methodName);
            }
            catch (InvocationTargetException ite) {
                throw new RuntimeException("InvocationTargetException accessing " + methodName);
            }
        }
        throw new RuntimeException("Method '" + methodName + "' not found");
    }
}

