/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.resolve;

import grails.util.BuildSettings;
import grails.util.CollectionUtils;
import grails.util.GrailsNameUtils;
import grails.util.Metadata;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.resolver.ChainResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLogger;
import org.codehaus.groovy.grails.resolve.EnhancedDefaultDependencyDescriptor;
import org.codehaus.groovy.grails.resolve.IvyDependencyManager;
import org.codehaus.groovy.grails.resolve.config.DependencyConfigurationConfigurer;
import org.codehaus.groovy.grails.resolve.config.DependencyConfigurationContext;
import org.codehaus.groovy.grails.resolve.maven.PomModuleDescriptorParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIvyDependencyManager {
    public static final String SNAPSHOT_CHANGING_PATTERN = ".*SNAPSHOT";
    public static Configuration BUILD_CONFIGURATION = new Configuration("build", Configuration.Visibility.PUBLIC, "Build system dependencies", new String[]{"default"}, true, null);
    public static Configuration COMPILE_CONFIGURATION = new Configuration("compile", Configuration.Visibility.PUBLIC, "Compile time dependencies", new String[]{"default"}, true, null);
    public static Configuration RUNTIME_CONFIGURATION = new Configuration("runtime", Configuration.Visibility.PUBLIC, "Runtime time dependencies", new String[]{"compile"}, true, null);
    public static Configuration TEST_CONFIGURATION = new Configuration("test", Configuration.Visibility.PUBLIC, "Testing dependencies", new String[]{"runtime"}, true, null);
    public static Configuration PROVIDED_CONFIGURATION = new Configuration("provided", Configuration.Visibility.PUBLIC, "Dependencies provided by the container", new String[]{"default"}, true, null);
    public static Configuration DOCS_CONFIGURATION = new Configuration("docs", Configuration.Visibility.PUBLIC, "Dependencies for the documenation engine", new String[]{"build"}, true, null);
    public static List<Configuration> ALL_CONFIGURATIONS = Arrays.asList(BUILD_CONFIGURATION, COMPILE_CONFIGURATION, RUNTIME_CONFIGURATION, TEST_CONFIGURATION, PROVIDED_CONFIGURATION, DOCS_CONFIGURATION);
    public static final ExcludeRule[] NO_EXCLUDE_RULES = new ExcludeRule[0];
    Map<String, List<String>> configurationMappings = CollectionUtils.newMap("runtime", Arrays.asList("default"), "build", Arrays.asList("default"), "compile", Arrays.asList("default"), "provided", Arrays.asList("default"), "docs", Arrays.asList("default"), "test", Arrays.asList("default"));
    protected boolean includeSource;
    protected boolean includeJavadoc;
    protected String[] configurationNames = this.configurationMappings.keySet().toArray(new String[this.configurationMappings.size()]);
    protected Set<ModuleId> modules = new HashSet<ModuleId>();
    protected Set<ModuleRevisionId> dependencies = new HashSet<ModuleRevisionId>();
    protected Set<DependencyDescriptor> dependencyDescriptors = new HashSet<DependencyDescriptor>();
    protected Set<DependencyDescriptor> pluginDependencyDescriptors = new HashSet<DependencyDescriptor>();
    protected Set<String> metadataRegisteredPluginNames = new HashSet<String>();
    protected Map<String, Collection<ModuleRevisionId>> orgToDepMap = new HashMap<String, Collection<ModuleRevisionId>>();
    protected Collection<String> usedConfigurations = new ConcurrentLinkedQueue<String>();
    protected Map<String, DependencyDescriptor> pluginNameToDescriptorMap = new ConcurrentHashMap<String, DependencyDescriptor>();
    protected String applicationName;
    protected String applicationVersion;
    protected DefaultModuleDescriptor moduleDescriptor;
    protected boolean hasApplicationDependencies = false;
    protected boolean readPom = false;
    protected final IvySettings ivySettings;
    protected final BuildSettings buildSettings;
    protected final Metadata metadata;
    protected boolean legacyResolve = true;
    private boolean offline;
    private ChainResolver chainResolver;
    ResolveEngine resolveEngine;
    MessageLogger logger;

    public AbstractIvyDependencyManager(IvySettings ivySettings, BuildSettings buildSettings, Metadata metadata) {
        this.ivySettings = ivySettings;
        this.buildSettings = buildSettings;
        this.metadata = metadata;
        ModuleDescriptorParserRegistry.getInstance().addParser((ModuleDescriptorParser)PomModuleDescriptorParser.getInstance());
        this.chainResolver = new ChainResolver();
        this.chainResolver.setName("cache");
        this.chainResolver.setReturnFirst(true);
        this.updateChangingPattern();
    }

    public boolean isLegacyResolve() {
        return this.legacyResolve;
    }

    public void setLegacyResolve(boolean legacyResolve) {
        this.legacyResolve = legacyResolve;
    }

    public ResolveEngine getResolveEngine() {
        return this.resolveEngine;
    }

    public void setResolveEngine(ResolveEngine resolveEngine) {
        this.resolveEngine = resolveEngine;
    }

    public MessageLogger getLogger() {
        return this.logger;
    }

    public void setLogger(MessageLogger logger) {
        Message.setDefaultLogger((MessageLogger)logger);
        this.logger = logger;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
        this.updateChangingPattern();
    }

    private void updateChangingPattern() {
        this.chainResolver.setChangingPattern(this.isOffline() ? null : SNAPSHOT_CHANGING_PATTERN);
    }

    public ChainResolver getChainResolver() {
        return this.chainResolver;
    }

    public BuildSettings getBuildSettings() {
        return this.buildSettings;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setChainResolver(ChainResolver chainResolver) {
        this.resolveEngine.setDictatorResolver((DependencyResolver)chainResolver);
        this.chainResolver = chainResolver;
        this.updateChangingPattern();
    }

    public IvyDependencyManager createCopy(BuildSettings settings) {
        IvyDependencyManager copy = new IvyDependencyManager(this.applicationName, this.applicationVersion, settings);
        copy.setOffline(this.isOffline());
        copy.setChainResolver(this.getChainResolver());
        copy.setResolveEngine(this.getResolveEngine());
        if (this.getLogger() != null) {
            copy.logger = this.getLogger();
        }
        return copy;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setIncludeSource(boolean includeSource) {
        this.includeSource = includeSource;
    }

    public void setIncludeJavadoc(boolean includeJavadoc) {
        this.includeJavadoc = includeJavadoc;
    }

    public IvySettings getIvySettings() {
        return this.ivySettings;
    }

    public DefaultModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    public void setModuleDescriptor(DefaultModuleDescriptor moduleDescriptor) {
        this.moduleDescriptor = moduleDescriptor;
    }

    public boolean hasApplicationDependencies() {
        return this.hasApplicationDependencies;
    }

    public Collection<String> getUsedConfigurations() {
        return this.usedConfigurations;
    }

    public void setUsedConfigurations(Collection<String> usedConfigurations) {
        this.usedConfigurations = usedConfigurations;
    }

    Set<DependencyDescriptor> getDependencyDescriptors() {
        return this.dependencyDescriptors;
    }

    public Set<String> getMetadataRegisteredPluginNames() {
        return this.metadataRegisteredPluginNames;
    }

    public void setMetadataRegisteredPluginNames(Set<String> metadataRegisteredPluginNames) {
        this.metadataRegisteredPluginNames = metadataRegisteredPluginNames;
    }

    public Set<DependencyDescriptor> getPluginDependencyDescriptors() {
        return this.pluginDependencyDescriptors;
    }

    Set<DependencyDescriptor> getDeclaredPluginDependencyDescriptors() {
        Set<DependencyDescriptor> descriptors = this.getPluginDependencyDescriptors();
        HashSet<DependencyDescriptor> declaredDescriptors = new HashSet<DependencyDescriptor>();
        for (DependencyDescriptor descriptor : descriptors) {
            if (!(descriptor instanceof EnhancedDefaultDependencyDescriptor) || ((EnhancedDefaultDependencyDescriptor)descriptor).isTransitivelyIncluded()) continue;
            declaredDescriptors.add(descriptor);
        }
        return declaredDescriptors;
    }

    public DependencyDescriptor getPluginDependencyDescriptor(String pluginName) {
        return this.pluginNameToDescriptorMap.get(pluginName);
    }

    public Set<String> getPluginDependencyNames() {
        return this.pluginNameToDescriptorMap.keySet();
    }

    public Set<ModuleRevisionId> getDependencies() {
        return this.dependencies;
    }

    boolean hasDependency(ModuleId mid) {
        return this.modules.contains(mid) || mid.getName().equals("grails-dependencies");
    }

    boolean hasDependency(String group, String name) {
        return this.hasDependency(ModuleId.newInstance((String)group, (String)name));
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    public String[] getConfigurationNames() {
        return this.configurationNames;
    }

    public Map<String, List<String>> getConfigurationMappings() {
        return this.configurationMappings;
    }

    public boolean getReadPom() {
        return this.readPom;
    }

    public void setReadPom(boolean flag) {
        this.readPom = flag;
    }

    public boolean isPluginTransitive(String pluginName) {
        DependencyDescriptor dd = this.pluginNameToDescriptorMap.get(pluginName);
        return dd == null || dd.isTransitive();
    }

    public boolean isPluginTransitivelyIncluded(String pluginName) {
        EnhancedDefaultDependencyDescriptor dd = (EnhancedDefaultDependencyDescriptor)this.pluginNameToDescriptorMap.get(pluginName);
        return dd != null && dd.isTransitivelyIncluded() && dd.isExported();
    }

    @Deprecated
    public void configureDependencyDescriptor(EnhancedDefaultDependencyDescriptor dependencyDescriptor, String scope) {
        this.configureDependencyDescriptor(dependencyDescriptor, scope, false);
    }

    @Deprecated
    public void configureDependencyDescriptor(EnhancedDefaultDependencyDescriptor dependencyDescriptor, String scope, boolean pluginMode) {
        if (pluginMode) {
            this.registerPluginDependency(scope, dependencyDescriptor);
        } else {
            this.registerDependency(scope, dependencyDescriptor);
        }
    }

    public void registerDependency(String scope, EnhancedDefaultDependencyDescriptor descriptor) {
        EnhancedDefaultDependencyDescriptor pluginDependencyDescriptor;
        String plugin = descriptor.getPlugin();
        if (plugin != null && (pluginDependencyDescriptor = (EnhancedDefaultDependencyDescriptor)this.getPluginDependencyDescriptor(plugin)) != null) {
            String pluginScope;
            ExcludeRule[] excludeRules = pluginDependencyDescriptor.getExcludeRules(scope);
            if (excludeRules != null) {
                for (ExcludeRule excludeRule : excludeRules) {
                    descriptor.addExcludeRule(scope, excludeRule);
                }
            }
            if ((pluginScope = pluginDependencyDescriptor.getScope()) != null && this.isCompileOrRuntimeScope(scope)) {
                scope = pluginScope;
            }
        }
        this.registerDependencyCommon(scope, descriptor, false);
        ModuleRevisionId revisionId = descriptor.getDependencyRevisionId();
        this.modules.add(revisionId.getModuleId());
        this.dependencies.add(revisionId);
        String org = revisionId.getOrganisation();
        if (this.orgToDepMap.containsKey(org)) {
            this.orgToDepMap.get(org).add(revisionId);
        } else {
            HashSet<ModuleRevisionId> deps = new HashSet<ModuleRevisionId>();
            deps.add(revisionId);
            this.orgToDepMap.put(org, deps);
        }
        this.dependencyDescriptors.add((DependencyDescriptor)descriptor);
        if (this.shouldIncludeDependency(descriptor)) {
            this.addToModuleDescriptor(scope, descriptor);
        }
    }

    private boolean areSameLogicalDependency(ModuleRevisionId lhs, ModuleRevisionId rhs) {
        return lhs.getModuleId().equals((Object)rhs.getModuleId()) && lhs.getRevision().equals(rhs.getRevision());
    }

    private void addToModuleDescriptor(String scope, EnhancedDefaultDependencyDescriptor descriptor) {
        boolean foundDependency = false;
        for (DependencyDescriptor existingDescriptor : this.moduleDescriptor.getDependencies()) {
            if (existingDescriptor instanceof EnhancedDefaultDependencyDescriptor) {
                EnhancedDefaultDependencyDescriptor existingEnhancedDefaultDependencyDescriptor = (EnhancedDefaultDependencyDescriptor)existingDescriptor;
                if (!descriptor.getScope().equals(existingEnhancedDefaultDependencyDescriptor.getScope())) continue;
            }
            if (!this.areSameLogicalDependency(descriptor.getDependencyRevisionId(), existingDescriptor.getDependencyRevisionId())) continue;
            foundDependency = true;
            for (DependencyArtifactDescriptor artifactToAdd : descriptor.getAllDependencyArtifacts()) {
                boolean foundArtifact = false;
                for (DependencyArtifactDescriptor existingArtifact : existingDescriptor.getAllDependencyArtifacts()) {
                    if (!existingArtifact.equals(artifactToAdd) || !existingArtifact.getExtraAttributes().equals(artifactToAdd.getExtraAttributes())) continue;
                    foundArtifact = true;
                    break;
                }
                if (foundArtifact) continue;
                ((DefaultDependencyDescriptor)existingDescriptor).addDependencyArtifact(scope, artifactToAdd);
            }
            break;
        }
        if (!foundDependency) {
            this.moduleDescriptor.addDependency((DependencyDescriptor)descriptor);
        }
    }

    private boolean isCompileOrRuntimeScope(String scope) {
        return scope.equals("runtime") || scope.equals("compile");
    }

    public void registerPluginDependency(String scope, EnhancedDefaultDependencyDescriptor descriptor) {
        ModuleId dependencyId = descriptor.getDependencyId();
        String name = dependencyId.getName();
        DependencyDescriptor existing = this.pluginNameToDescriptorMap.get(name);
        if (existing != null && descriptor.isTransitivelyIncluded()) {
            ModuleRevisionId dependencyRevisionId = existing.getDependencyRevisionId();
            if (dependencyRevisionId.equals((Object)descriptor.getDependencyRevisionId())) {
                return;
            }
            if (descriptor.getPlugin() != null && existing instanceof EnhancedDefaultDependencyDescriptor && ((EnhancedDefaultDependencyDescriptor)existing).getPlugin() == null) {
                return;
            }
        }
        this.registerDependencyCommon(scope, descriptor, true);
        this.pluginNameToDescriptorMap.put(name, (DependencyDescriptor)descriptor);
        this.pluginDependencyDescriptors.add((DependencyDescriptor)descriptor);
        if (this.shouldIncludeDependency(descriptor)) {
            this.addToModuleDescriptor(scope, descriptor);
        }
    }

    private boolean shouldIncludeDependency(EnhancedDefaultDependencyDescriptor descriptor) {
        return descriptor.isExported() || this.buildSettings.isPluginProject() && this.isExposedByThisPlugin(descriptor);
    }

    private boolean isExposedByThisPlugin(EnhancedDefaultDependencyDescriptor descriptor) {
        File basePluginDescriptor = this.buildSettings.getBasePluginDescriptor();
        if (basePluginDescriptor != null) {
            String basePluginName = GrailsNameUtils.getPluginName(basePluginDescriptor.getName());
            String plugin = descriptor.getPlugin();
            return plugin == null || plugin.equals(basePluginName);
        }
        return false;
    }

    public void parseDependencies(Closure definition) {
        if (definition == null || this.applicationName == null || this.applicationVersion == null) {
            return;
        }
        if (this.moduleDescriptor == null) {
            this.setModuleDescriptor((DefaultModuleDescriptor)this.createModuleDescriptor());
        }
        this.doParseDependencies(definition, null, null, NO_EXCLUDE_RULES);
        if (this.readPom && this.buildSettings != null) {
            this.registerPomDependencies();
        }
        if (this.metadata == null) {
            return;
        }
        Map<String, String> metadataDeclaredPlugins = this.metadata.getInstalledPlugins();
        if (metadataDeclaredPlugins != null) {
            this.addMetadataPluginDependencies(metadataDeclaredPlugins);
        }
    }

    public void parseDependencies(String pluginName, Closure<?> definition) throws IllegalStateException {
        if (definition == null) {
            return;
        }
        if (this.moduleDescriptor == null) {
            throw new IllegalStateException("Call parseDependencies(Closure) first to parse the application dependencies");
        }
        String scope = this.getParentScope(pluginName);
        this.doParseDependencies(definition, pluginName, scope, NO_EXCLUDE_RULES);
    }

    public void parseDependencies(String pluginName, Closure<?> definition, ExcludeRule[] excludeRules) throws IllegalStateException {
        if (definition == null) {
            return;
        }
        if (this.moduleDescriptor == null) {
            throw new IllegalStateException("Call parseDependencies(Closure) first to parse the application dependencies");
        }
        String scope = this.getParentScope(pluginName);
        this.doParseDependencies(definition, pluginName, scope, excludeRules);
    }

    private String getParentScope(String pluginName) {
        DependencyDescriptor pluginDependencyDescriptor = this.getPluginDependencyDescriptor(pluginName);
        String scope = null;
        if (pluginDependencyDescriptor instanceof EnhancedDefaultDependencyDescriptor) {
            scope = ((EnhancedDefaultDependencyDescriptor)pluginDependencyDescriptor).getScope();
        }
        return scope;
    }

    private void doParseDependencies(Closure<?> definition, String pluginName, String scope, ExcludeRule[] excludeRules) {
        IvyDependencyManager dependencyManager = (IvyDependencyManager)this;
        DependencyConfigurationContext context = pluginName == null ? DependencyConfigurationContext.forApplication(dependencyManager) : DependencyConfigurationContext.forPlugin(dependencyManager, pluginName);
        context.setOffline(this.offline);
        context.setParentScope(scope);
        context.setExcludeRules(excludeRules);
        definition.setDelegate((Object)new DependencyConfigurationConfigurer(context));
        definition.setResolveStrategy(1);
        definition.call();
    }

    private void registerDependencyCommon(String scope, EnhancedDefaultDependencyDescriptor descriptor, boolean isPluginDep) {
        if (this.offline && descriptor.isChanging()) {
            descriptor.setChanging(false);
        }
        this.registerUsedConfigurationIfNecessary(scope);
        if (descriptor.getModuleConfigurations().length == 0) {
            this.addDefaultModuleConfigurations(descriptor, scope, isPluginDep);
        }
        if (!descriptor.isInherited()) {
            this.hasApplicationDependencies = true;
        }
    }

    private void registerUsedConfigurationIfNecessary(String configurationName) {
        if (!this.usedConfigurations.contains(configurationName)) {
            this.usedConfigurations.add(configurationName);
        }
    }

    private void addDefaultModuleConfigurations(EnhancedDefaultDependencyDescriptor descriptor, String configurationName, boolean pluginDep) {
        List<String> mappings = this.configurationMappings.get(configurationName);
        if (mappings == null) {
            return;
        }
        String org = descriptor.getDependencyId().getOrganisation();
        if (!(pluginDep || "org.grails".equals(org) || "org.springframework.uaa".equals(org))) {
            mappings = new ArrayList<String>(mappings);
            if (this.includeJavadoc) {
                mappings.add("javadoc");
            }
            if (this.includeSource) {
                mappings.add("sources");
            }
        }
        for (String m : mappings) {
            descriptor.addDependencyConfiguration(configurationName, m);
        }
    }

    protected ArtifactId createExcludeArtifactId(String excludeName) {
        return this.createExcludeArtifactId(excludeName, "*");
    }

    protected ArtifactId createExcludeArtifactId(String excludeName, String group) {
        ModuleId mid = ModuleId.newInstance((String)group, (String)excludeName);
        return new ArtifactId(mid, "*", "*", "*");
    }

    public ModuleDescriptor createModuleDescriptor() {
        DefaultModuleDescriptor moduleDescriptor = DefaultModuleDescriptor.newDefaultInstance((ModuleRevisionId)ModuleRevisionId.newInstance((String)"org.grails.internal", (String)this.applicationName, (String)this.applicationVersion));
        moduleDescriptor.addConfiguration(BUILD_CONFIGURATION);
        moduleDescriptor.addConfiguration(COMPILE_CONFIGURATION);
        moduleDescriptor.addConfiguration(RUNTIME_CONFIGURATION);
        moduleDescriptor.addConfiguration(TEST_CONFIGURATION);
        moduleDescriptor.addConfiguration(PROVIDED_CONFIGURATION);
        moduleDescriptor.addConfiguration(DOCS_CONFIGURATION);
        return moduleDescriptor;
    }

    public boolean isExcludedFromPlugin(String plugin, String dependencyName) {
        DependencyDescriptor dd = this.pluginNameToDescriptorMap.get(plugin);
        if (dd == null) {
            return false;
        }
        if (!dd.isTransitive()) {
            return true;
        }
        ArtifactId aid = this.createExcludeArtifactId(dependencyName);
        return this.isExcludedFromPlugin(dd, aid);
    }

    public boolean isExcludedFromPlugin(DependencyDescriptor currentPlugin, ArtifactId dependency) {
        return currentPlugin != null && currentPlugin.doesExclude(this.configurationNames, dependency);
    }

    public Set<String> getPluginExcludes(String plugin) {
        HashSet<String> excludes = new HashSet<String>();
        DependencyDescriptor dd = this.pluginNameToDescriptorMap.get(plugin);
        if (dd != null) {
            for (ExcludeRule er : dd.getAllExcludeRules()) {
                excludes.add(er.getId().getName());
            }
        }
        return excludes;
    }

    public DependencyDescriptor[] readDependenciesFromPOM() {
        DependencyDescriptor[] fixedDependencies = null;
        File pom = new File(this.buildSettings.getBaseDir().getPath(), "pom.xml");
        if (pom.exists()) {
            PomModuleDescriptorParser parser = PomModuleDescriptorParser.getInstance();
            try {
                ModuleDescriptor md = parser.parseDescriptor((ParserSettings)this.ivySettings, pom.toURI().toURL(), false);
                fixedDependencies = md.getDependencies();
            }
            catch (MalformedURLException e) {
            }
            catch (ParseException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return fixedDependencies;
    }

    private void registerPomDependencies() {
        DependencyDescriptor[] pomDependencies = this.readDependenciesFromPOM();
        if (pomDependencies == null) {
            return;
        }
        for (DependencyDescriptor dependencyDescriptor : pomDependencies) {
            this.registerPomDependency(dependencyDescriptor);
        }
    }

    private void registerPomDependency(DependencyDescriptor dependencyDescriptor) {
        ModuleRevisionId moduleRevisionId = dependencyDescriptor.getDependencyRevisionId();
        ModuleId moduleId = (moduleRevisionId = ModuleRevisionId.newInstance((String)moduleRevisionId.getOrganisation(), (String)moduleRevisionId.getName(), (String)moduleRevisionId.getRevision())).getModuleId();
        if (this.hasDependency(moduleId)) {
            return;
        }
        String scope = dependencyDescriptor.getModuleConfigurations()[0];
        EnhancedDefaultDependencyDescriptor enhancedDependencyDescriptor = new EnhancedDefaultDependencyDescriptor(moduleRevisionId, false, true, scope);
        for (ExcludeRule excludeRule : dependencyDescriptor.getAllExcludeRules()) {
            ModuleId excludedModule = excludeRule.getId().getModuleId();
            enhancedDependencyDescriptor.addRuleForModuleId(excludedModule, scope);
        }
        DependencyArtifactDescriptor[] allDependencyArtifacts = dependencyDescriptor.getAllDependencyArtifacts();
        boolean isPlugin = false;
        for (DependencyArtifactDescriptor dependencyArtifact : allDependencyArtifacts) {
            if (dependencyArtifact.getType() == null || !dependencyArtifact.getType().equals("zip")) continue;
            isPlugin = true;
            break;
        }
        if (isPlugin) {
            this.registerPluginDependency(scope, enhancedDependencyDescriptor);
        } else {
            this.registerDependency(scope, enhancedDependencyDescriptor);
        }
    }

    private void addMetadataPluginDependencies(Map<String, String> plugins) {
        for (Map.Entry<String, String> plugin : plugins.entrySet()) {
            String name = plugin.getKey().contains(":") ? plugin.getKey().split(":")[1] : plugin.getKey();
            String group = plugin.getKey().contains(":") ? plugin.getKey().split(":")[0] : "org.grails.plugins";
            String version = plugin.getValue();
            if (this.pluginNameToDescriptorMap.containsKey(name)) continue;
            String scope = "runtime";
            this.metadataRegisteredPluginNames.add(name);
            ModuleRevisionId mrid = ModuleRevisionId.newInstance((String)group, (String)name, (String)version);
            EnhancedDefaultDependencyDescriptor enhancedDescriptor = new EnhancedDefaultDependencyDescriptor(mrid, true, true, scope);
            if (this.buildSettings.isPluginProject()) {
                enhancedDescriptor.setExport(false);
            }
            this.registerPluginDependency(scope, enhancedDescriptor);
        }
    }
}

