/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.resolve;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIvyDependencyManager {
    public static Configuration BUILD_CONFIGURATION = new Configuration("build", Configuration.Visibility.PUBLIC, "Build system dependencies", new String[]{"default"}, true, null);
    public static Configuration COMPILE_CONFIGURATION = new Configuration("compile", Configuration.Visibility.PUBLIC, "Compile time dependencies", new String[]{"default"}, true, null);
    public static Configuration RUNTIME_CONFIGURATION = new Configuration("runtime", Configuration.Visibility.PUBLIC, "Runtime time dependencies", new String[]{"compile"}, true, null);
    public static Configuration TEST_CONFIGURATION = new Configuration("test", Configuration.Visibility.PUBLIC, "Testing dependencies", new String[]{"runtime"}, true, null);
    public static Configuration PROVIDED_CONFIGURATION = new Configuration("provided", Configuration.Visibility.PUBLIC, "Dependencies provided by the container", new String[]{"default"}, true, null);
    public static Configuration DOCS_CONFIGURATION = new Configuration("docs", Configuration.Visibility.PUBLIC, "Dependencies for the documenation engine", new String[]{"build"}, true, null);
    public static List<Configuration> ALL_CONFIGURATIONS = Arrays.asList(BUILD_CONFIGURATION, COMPILE_CONFIGURATION, RUNTIME_CONFIGURATION, TEST_CONFIGURATION, PROVIDED_CONFIGURATION, DOCS_CONFIGURATION);
    Map<String, List<String>> configurationMappings = new HashMap<String, List<String>>(){
        {
            this.put("runtime", Arrays.asList("runtime(*)", "master(*)"));
            this.put("build", Arrays.asList("default"));
            this.put("compile", Arrays.asList("'compile(*)", "master(*)"));
            this.put("provided", Arrays.asList("'compile(*)", "master(*)"));
            this.put("docs", Arrays.asList("'compile(*)", "master(*)"));
            this.put("test", Arrays.asList("''runtime(*)'(*)", "master(*)"));
        }
    };
    protected String[] configurationNames = this.configurationMappings.keySet().toArray(new String[this.configurationMappings.size()]);
    protected Set<ModuleId> modules = new HashSet<ModuleId>();
    protected Set<ModuleRevisionId> dependencies = new HashSet<ModuleRevisionId>();
    protected Set<DependencyDescriptor> dependencyDescriptors = new HashSet<DependencyDescriptor>();
    protected Set<DependencyDescriptor> pluginDependencyDescriptors = new HashSet<DependencyDescriptor>();
    protected Set<String> pluginDependencyNames = new HashSet<String>();
    protected Set<String> metadataRegisteredPluginNames = new HashSet<String>();
    protected Map<String, Collection<ModuleRevisionId>> orgToDepMap = new HashMap<String, Collection<ModuleRevisionId>>();
    protected Map<String, DependencyDescriptor> pluginNameToDescriptorMap = new ConcurrentHashMap<String, DependencyDescriptor>();
    protected String applicationName;
    protected String applicationVersion;

    Set<DependencyDescriptor> getDependencyDescriptors() {
        return this.dependencyDescriptors;
    }

    public Set<String> getMetadataRegisteredPluginNames() {
        return this.metadataRegisteredPluginNames;
    }

    public void setMetadataRegisteredPluginNames(Set<String> metadataRegisteredPluginNames) {
        this.metadataRegisteredPluginNames = metadataRegisteredPluginNames;
    }

    Set<DependencyDescriptor> getPluginDependencyDescriptors() {
        return this.pluginDependencyDescriptors;
    }

    public DependencyDescriptor getPluginDependencyDescriptor(String pluginName) {
        return this.pluginNameToDescriptorMap.get(pluginName);
    }

    public Set<String> getPluginDependencyNames() {
        return this.pluginDependencyNames;
    }

    public Set<ModuleRevisionId> getDependencies() {
        return this.dependencies;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    public String[] getConfigurationNames() {
        return this.configurationNames;
    }

    public Map<String, List<String>> getConfigurationMappings() {
        return this.configurationMappings;
    }

    public boolean isPluginTransitive(String pluginName) {
        DependencyDescriptor dd = this.pluginNameToDescriptorMap.get(pluginName);
        return dd == null || dd.isTransitive();
    }

    public void addDependency(ModuleRevisionId revisionId) {
        this.modules.add(revisionId.getModuleId());
        this.dependencies.add(revisionId);
        String org = revisionId.getOrganisation();
        if (this.orgToDepMap.containsKey(org)) {
            this.orgToDepMap.get(org).add(revisionId);
        } else {
            HashSet<ModuleRevisionId> deps = new HashSet<ModuleRevisionId>();
            deps.add(revisionId);
            this.orgToDepMap.put(org, deps);
        }
    }

    protected ArtifactId createExcludeArtifactId(String excludeName) {
        return this.createExcludeArtifactId(excludeName, "*");
    }

    protected ArtifactId createExcludeArtifactId(String excludeName, String group) {
        ModuleId mid = ModuleId.newInstance((String)group, (String)excludeName);
        return new ArtifactId(mid, "*", "*", "*");
    }

    public void addDependencyDescriptor(DependencyDescriptor dd) {
        if (dd != null) {
            this.dependencyDescriptors.add(dd);
            this.addDependency(dd.getDependencyRevisionId());
        }
    }

    public ModuleDescriptor createModuleDescriptor() {
        DefaultModuleDescriptor moduleDescriptor = DefaultModuleDescriptor.newDefaultInstance((ModuleRevisionId)ModuleRevisionId.newInstance((String)"org.grails.internal", (String)this.applicationName, (String)this.applicationVersion));
        moduleDescriptor.addConfiguration(BUILD_CONFIGURATION);
        moduleDescriptor.addConfiguration(COMPILE_CONFIGURATION);
        moduleDescriptor.addConfiguration(RUNTIME_CONFIGURATION);
        moduleDescriptor.addConfiguration(TEST_CONFIGURATION);
        moduleDescriptor.addConfiguration(PROVIDED_CONFIGURATION);
        moduleDescriptor.addConfiguration(DOCS_CONFIGURATION);
        return moduleDescriptor;
    }

    public boolean isExcludedFromPlugin(String plugin, String dependencyName) {
        DependencyDescriptor dd = this.pluginNameToDescriptorMap.get(plugin);
        if (dd == null) {
            return false;
        }
        if (!dd.isTransitive()) {
            return true;
        }
        ArtifactId aid = this.createExcludeArtifactId(dependencyName);
        return this.isExcludedFromPlugin(dd, aid);
    }

    public boolean isExcludedFromPlugin(DependencyDescriptor currentPlugin, ArtifactId dependency) {
        return currentPlugin != null && currentPlugin.doesExclude(this.configurationNames, dependency);
    }

    public Set<String> getPluginExcludes(String plugin) {
        HashSet<String> excludes = new HashSet<String>();
        DependencyDescriptor dd = this.pluginNameToDescriptorMap.get(plugin);
        if (dd != null) {
            for (ExcludeRule er : dd.getAllExcludeRules()) {
                excludes.add(er.getId().getName());
            }
        }
        return excludes;
    }
}

