/*
 * Decompiled with CFR 0.152.
 */
package org.gradlex.javamodule.moduleinfo;

import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradlex.javamodule.moduleinfo.AutomaticModuleName;
import org.gradlex.javamodule.moduleinfo.KnownModule;
import org.gradlex.javamodule.moduleinfo.ModuleInfo;
import org.gradlex.javamodule.moduleinfo.ModuleSpec;

public abstract class ExtraJavaModuleInfoPluginExtension {
    static Attribute<Boolean> JAVA_MODULE_ATTRIBUTE = Attribute.of((String)"javaModule", Boolean.class);

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ConfigurationContainer getConfigurations();

    public abstract MapProperty<String, ModuleSpec> getModuleSpecs();

    public abstract Property<Boolean> getFailOnMissingModuleInfo();

    public abstract Property<Boolean> getFailOnAutomaticModules();

    public abstract Property<Boolean> getFailOnModifiedDerivedModuleNames();

    public abstract Property<Boolean> getSkipLocalJars();

    public abstract Property<Boolean> getDeriveAutomaticModuleNamesFromFileNames();

    public abstract Property<String> getVersionsProvidingConfiguration();

    public void module(String identifier, String moduleName) {
        this.module(identifier, moduleName, (String)null);
    }

    public void module(Provider<MinimalExternalModuleDependency> alias, String moduleName) {
        this.module(((MinimalExternalModuleDependency)alias.get()).getModule().toString(), moduleName);
    }

    public void module(String identifier, String moduleName, @Nullable String moduleVersion) {
        this.module(identifier, moduleName, moduleVersion, (Action<? super ModuleInfo>)((Action)m -> {
            m.exportAllPackages();
            if (identifier.contains(":")) {
                m.requireAllDefinedDependencies();
            }
        }));
    }

    public void module(Provider<MinimalExternalModuleDependency> alias, String moduleName, @Nullable String moduleVersion) {
        this.module(((MinimalExternalModuleDependency)alias.get()).getModule().toString(), moduleName, moduleVersion);
    }

    public void module(String identifier, String moduleName, @Nullable Action<? super ModuleInfo> conf) {
        this.module(identifier, moduleName, null, conf);
    }

    public void module(Provider<MinimalExternalModuleDependency> alias, String moduleName, @Nullable Action<? super ModuleInfo> conf) {
        this.module(((MinimalExternalModuleDependency)alias.get()).getModule().toString(), moduleName, conf);
    }

    public void module(String identifier, String moduleName, @Nullable String moduleVersion, @Nullable Action<? super ModuleInfo> conf) {
        ModuleInfo moduleInfo = new ModuleInfo(identifier, moduleName, moduleVersion, this.getObjects());
        if (conf != null) {
            conf.execute((Object)moduleInfo);
        }
        this.getModuleSpecs().put((Object)identifier, (Object)moduleInfo);
    }

    public void module(Provider<MinimalExternalModuleDependency> alias, String moduleName, @Nullable String moduleVersion, @Nullable Action<? super ModuleInfo> conf) {
        this.module(((MinimalExternalModuleDependency)alias.get()).getModule().toString(), moduleName, moduleVersion, conf);
    }

    public void automaticModule(String identifier, String moduleName) {
        this.automaticModule(identifier, moduleName, null);
    }

    public void automaticModule(Provider<MinimalExternalModuleDependency> alias, String moduleName) {
        this.automaticModule(((MinimalExternalModuleDependency)alias.get()).getModule().toString(), moduleName, null);
    }

    public void automaticModule(String identifier, String moduleName, @Nullable Action<? super AutomaticModuleName> conf) {
        AutomaticModuleName automaticModuleName = new AutomaticModuleName(identifier, moduleName);
        if (conf != null) {
            conf.execute((Object)automaticModuleName);
        }
        this.getModuleSpecs().put((Object)identifier, (Object)automaticModuleName);
    }

    public void automaticModule(Provider<MinimalExternalModuleDependency> alias, String moduleName, @Nullable Action<? super AutomaticModuleName> conf) {
        this.automaticModule(((MinimalExternalModuleDependency)alias.get()).getModule().toString(), moduleName, conf);
    }

    public void knownModule(String coordinates, String moduleName) {
        this.getModuleSpecs().put((Object)coordinates, (Object)new KnownModule(coordinates, moduleName));
    }

    public void knownModule(Provider<MinimalExternalModuleDependency> alias, String moduleName) {
        this.knownModule(((MinimalExternalModuleDependency)alias.get()).getModule().toString(), moduleName);
    }

    public void activate(SourceSet sourceSet) {
        NamedDomainObjectProvider runtimeClasspath = this.getConfigurations().named(sourceSet.getRuntimeClasspathConfigurationName());
        NamedDomainObjectProvider compileClasspath = this.getConfigurations().named(sourceSet.getCompileClasspathConfigurationName());
        NamedDomainObjectProvider annotationProcessor = this.getConfigurations().named(sourceSet.getAnnotationProcessorConfigurationName());
        this.activate(runtimeClasspath);
        this.activate(compileClasspath);
        this.activate(annotationProcessor);
    }

    public void activate(Configuration resolvable) {
        resolvable.getAttributes().attribute(JAVA_MODULE_ATTRIBUTE, (Object)true);
    }

    public void activate(NamedDomainObjectProvider<?> sourceSetOrResolvable) {
        Object realized = sourceSetOrResolvable.get();
        if (realized instanceof SourceSet) {
            this.activate((SourceSet)realized);
        } else if (realized instanceof Configuration) {
            this.activate((Configuration)realized);
        } else {
            throw new RuntimeException("Not SourceSet or Configuration: " + realized);
        }
    }

    public void deactivate(SourceSet sourceSet) {
        NamedDomainObjectProvider runtimeClasspath = this.getConfigurations().named(sourceSet.getRuntimeClasspathConfigurationName());
        NamedDomainObjectProvider compileClasspath = this.getConfigurations().named(sourceSet.getCompileClasspathConfigurationName());
        NamedDomainObjectProvider annotationProcessor = this.getConfigurations().named(sourceSet.getAnnotationProcessorConfigurationName());
        this.deactivate(runtimeClasspath);
        this.deactivate(compileClasspath);
        this.deactivate(annotationProcessor);
    }

    public void deactivate(Configuration resolvable) {
        resolvable.getAttributes().attribute(JAVA_MODULE_ATTRIBUTE, (Object)false);
    }

    public void deactivate(NamedDomainObjectProvider<?> sourceSetOrResolvable) {
        Object realized = sourceSetOrResolvable.get();
        if (realized instanceof SourceSet) {
            this.deactivate((SourceSet)realized);
        } else if (realized instanceof Configuration) {
            this.deactivate((Configuration)realized);
        } else {
            throw new RuntimeException("Not SourceSet or Configuration: " + realized);
        }
    }
}

