/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapperupgrade;

import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import org.gradle.process.ExecOperations;
import org.gradle.wrapperupgrade.BuildToolStrategy;
import org.gradle.wrapperupgrade.ExecUtils;
import org.gradle.wrapperupgrade.MavenMetadataFetcher;

public final class MavenBuildToolStrategy
implements BuildToolStrategy {
    private final MavenMetadataFetcher mavenMetadataFetcher = new MavenMetadataFetcher();

    @Override
    public String buildToolName() {
        return "Maven";
    }

    @Override
    public BuildToolStrategy.VersionInfo lookupLatestVersion(boolean allowPreRelease) throws IOException {
        return this.mavenMetadataFetcher.fetchLatestVersion(allowPreRelease).map(latestVersion -> new BuildToolStrategy.VersionInfo(latestVersion.toString(), null)).orElseThrow(() -> new IllegalStateException("Could not determine latest Maven version"));
    }

    @Override
    public BuildToolStrategy.VersionInfo extractCurrentVersion(Path rootProjectDir) throws IOException {
        return BuildToolStrategy.extractBuildToolVersion(rootProjectDir, ".mvn/wrapper/maven-wrapper.properties", "distributionUrl", null, "apache-maven-(.*)-bin.zip");
    }

    @Override
    public void runWrapper(ExecOperations execOperations, Path rootProjectDir, BuildToolStrategy.VersionInfo version) {
        ExecUtils.execMavenCmd(execOperations, rootProjectDir, "-B", "-N", "wrapper:wrapper", "-Dmaven=" + version.version);
    }

    @Override
    public List<Path> wrapperFiles(Path rootProjectDir) {
        LinkedList<Path> paths = new LinkedList<Path>();
        paths.add(rootProjectDir.resolve("mvnw"));
        paths.add(rootProjectDir.resolve("mvnw.cmd"));
        paths.add(rootProjectDir.resolve(".mvn").resolve("wrapper"));
        return paths;
    }

    @Override
    public String releaseNotesLink(String buildToolVersion) {
        return "https://maven.apache.org/docs/$VERSION/release-notes.html".replace("$VERSION", buildToolVersion);
    }
}

