/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapperupgrade;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.gradle.process.ExecOperations;
import org.gradle.wrapperupgrade.GradleBuildToolStrategy;
import org.gradle.wrapperupgrade.MavenBuildToolStrategy;

public interface BuildToolStrategy {
    public static final BuildToolStrategy GRADLE = new GradleBuildToolStrategy();
    public static final BuildToolStrategy MAVEN = new MavenBuildToolStrategy();

    public String buildToolName();

    public VersionInfo lookupLatestVersion(boolean var1) throws IOException;

    public VersionInfo extractCurrentVersion(Path var1) throws IOException;

    public void runWrapper(ExecOperations var1, Path var2, VersionInfo var3);

    public List<Path> wrapperFiles(Path var1);

    public String releaseNotesLink(String var1);

    public static VersionInfo extractBuildToolVersion(Path rootProjectDir, String wrapperPropertiesFile, String distributionUrlProperty, String distributionChecksumProperty, String versionRegExp) throws IOException {
        try (InputStream is = Files.newInputStream(rootProjectDir.resolve(wrapperPropertiesFile), new OpenOption[0]);){
            Properties wrapperProperties = new Properties();
            wrapperProperties.load(is);
            VersionInfo versionInfo = BuildToolStrategy.extractBuildToolVersion(wrapperProperties, wrapperPropertiesFile, distributionUrlProperty, distributionChecksumProperty, versionRegExp);
            return versionInfo;
        }
    }

    public static VersionInfo extractBuildToolVersion(Properties props, String wrapperPropertiesFile, String distributionUrlProperty, String distributionChecksumProperty, String versionRegExp) {
        String distributionUrl = props.getProperty(distributionUrlProperty);
        if (distributionUrl != null) {
            Matcher matcher = Pattern.compile(versionRegExp).matcher(distributionUrl);
            if (matcher.find()) {
                return new VersionInfo(matcher.group(1), distributionChecksumProperty != null ? props.getProperty(distributionChecksumProperty) : null);
            }
            throw new IllegalStateException(String.format("Could not extract version from property '%s': %s", distributionUrlProperty, distributionUrl));
        }
        throw new IllegalStateException(String.format("Could not find property '%s' in file %s", distributionUrlProperty, wrapperPropertiesFile));
    }

    public static final class VersionInfo {
        public String version;
        public Optional<String> checksum;

        public VersionInfo(String version, @Nullable String checksum) {
            this.version = version;
            this.checksum = Optional.ofNullable(checksum);
        }
    }
}

