/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.testsreader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.gradle.testretry.org.objectweb.asm.ClassReader;
import org.gradle.testretry.org.objectweb.asm.ClassVisitor;
import org.jetbrains.annotations.NotNull;

public final class TestsReader {
    private final Set<File> testClassesDirs;
    private final Iterable<File> classpath;

    public TestsReader(Set<File> testClassesDirs, Iterable<File> classpath) {
        this.testClassesDirs = testClassesDirs;
        this.classpath = classpath;
    }

    public <R> Optional<R> readTestClassDirClass(String className, Supplier<? extends Visitor<R>> factory) {
        return this.testClassesDirs.stream().map(dir -> new File((File)dir, this.classFileName(className))).filter(File::exists).findFirst().map(file -> this.visitClassFile((File)file, (Visitor)factory.get()));
    }

    public <R> Optional<R> readClass(String className, Supplier<? extends Visitor<R>> factory) {
        Optional<R> opt = this.readTestClassDirClass(className, factory);
        if (opt.isPresent()) {
            return opt;
        }
        return this.readClasspathClass(className, factory);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R> R visitClassFile(File file, Visitor<R> visitor) {
        try (FileInputStream in = new FileInputStream(file);){
            R r = this.visit(in, visitor);
            return r;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private <R> R visit(InputStream in, Visitor<R> visitor) throws IOException {
        ClassReader classReader = new ClassReader(in);
        classReader.accept(visitor, 0);
        return visitor.getResult();
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private <R> Optional<R> readClasspathClass(String className, Supplier<? extends Visitor<R>> factory) {
        String classFileName = this.classFileName(className);
        for (File file : this.classpath) {
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                File classFile = new File(file, classFileName);
                if (!classFile.exists()) continue;
                return Optional.of(this.visitClassFile(classFile, factory.get()));
            }
            if (!file.getName().endsWith(".jar")) continue;
            try {
                JarFile jarFile = new JarFile(file);
                Throwable throwable = null;
                try {
                    Optional<JarEntry> classFile = jarFile.stream().filter(maybeClass -> maybeClass.getName().equals(classFileName)).findAny();
                    if (!classFile.isPresent()) continue;
                    try (InputStream is = jarFile.getInputStream(classFile.get());){
                        Optional<R> optional = Optional.of(this.visit(is, factory.get()));
                        return optional;
                    }
                    {
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                    }
                }
                finally {
                    if (jarFile == null) continue;
                    if (throwable != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    jarFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        return Optional.empty();
    }

    @NotNull
    private String classFileName(String className) {
        return className.replace('.', '/') + ".class";
    }

    public static abstract class Visitor<T>
    extends ClassVisitor {
        public Visitor() {
            super(458752);
        }

        public abstract T getResult();
    }
}

