/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.filter;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.testretry.internal.filter.AnnotationInspector;
import org.gradle.testretry.internal.filter.GlobPattern;

public class RetryFilter {
    private final AnnotationInspector annotationInspector;
    private final Set<GlobPattern> includeClasses;
    private final Set<GlobPattern> includeAnnotationClasses;
    private final Set<GlobPattern> excludeClasses;
    private final Set<GlobPattern> excludeAnnotationClasses;

    public RetryFilter(AnnotationInspector annotationInspector, Collection<String> includeClasses, Collection<String> includeAnnotationClasses, Collection<String> excludeClasses, Collection<String> excludeAnnotationClasses) {
        this.annotationInspector = annotationInspector;
        this.includeClasses = RetryFilter.toPatterns(includeClasses);
        this.includeAnnotationClasses = RetryFilter.toPatterns(includeAnnotationClasses);
        this.excludeClasses = RetryFilter.toPatterns(excludeClasses);
        this.excludeAnnotationClasses = RetryFilter.toPatterns(excludeAnnotationClasses);
    }

    public boolean canRetry(String className) {
        if (!this.includeClasses.isEmpty() && !RetryFilter.anyMatch(this.includeClasses, className)) {
            return false;
        }
        if (RetryFilter.anyMatch(this.excludeClasses, className)) {
            return false;
        }
        Set<String> annotations = null;
        if (!(this.includeAnnotationClasses.isEmpty() || !(annotations = this.annotationInspector.getClassAnnotations(className)).isEmpty() && RetryFilter.anyMatch(this.includeAnnotationClasses, annotations))) {
            return false;
        }
        if (!this.excludeAnnotationClasses.isEmpty()) {
            annotations = annotations == null ? this.annotationInspector.getClassAnnotations(className) : annotations;
            return !RetryFilter.anyMatch(this.excludeAnnotationClasses, annotations);
        }
        return true;
    }

    private static boolean anyMatch(Set<GlobPattern> patterns, String string) {
        return RetryFilter.anyMatch(patterns, Collections.singleton(string));
    }

    private static boolean anyMatch(Set<GlobPattern> patterns, Set<String> strings) {
        return patterns.stream().anyMatch(p -> strings.stream().anyMatch(p::matches));
    }

    private static Set<GlobPattern> toPatterns(Collection<String> strings) {
        return strings.stream().map(GlobPattern::from).collect(Collectors.toSet());
    }
}

