/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.executer.framework;

import java.lang.reflect.Constructor;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestFramework;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.junit.JUnitOptions;
import org.gradle.testretry.internal.executer.TestFrameworkTemplate;
import org.gradle.testretry.internal.executer.TestNames;
import org.gradle.testretry.internal.executer.framework.BaseJunitTestFrameworkStrategy;
import org.gradle.testretry.internal.executer.framework.TestFrameworkProvider;
import org.gradle.testretry.internal.executer.framework.TestFrameworkStrategy;

final class JunitTestFrameworkStrategy
extends BaseJunitTestFrameworkStrategy
implements TestFrameworkStrategy {
    JunitTestFrameworkStrategy() {
    }

    @Override
    public TestFramework createRetrying(TestFrameworkTemplate template, TestFramework testFramework, TestNames failedTests) {
        DefaultTestFilter failedTestsFilter = this.testFilterFor(failedTests, true, template);
        return JunitTestFrameworkProvider.testFrameworkProvider(template, testFramework).testFrameworkFor(failedTestsFilter);
    }

    static class JunitTestFrameworkProvider {
        JunitTestFrameworkProvider() {
        }

        static TestFrameworkProvider testFrameworkProvider(TestFrameworkTemplate template, TestFramework testFramework) {
            if (TestFrameworkStrategy.gradleVersionIsAtLeast("8.0")) {
                return new TestFrameworkProvider.ProviderForCurrentGradleVersion(testFramework);
            }
            return new ProviderForGradleOlderThanV8(template);
        }

        static class ProviderForGradleOlderThanV8
        implements TestFrameworkProvider {
            private final TestFrameworkTemplate template;

            ProviderForGradleOlderThanV8(TestFrameworkTemplate template) {
                this.template = template;
            }

            @Override
            public TestFramework testFrameworkFor(DefaultTestFilter failedTestsFilter) {
                JUnitTestFramework retryTestFramework = ProviderForGradleOlderThanV8.newInstance(this.template.task, failedTestsFilter);
                ProviderForGradleOlderThanV8.copyOptions((JUnitOptions)this.template.task.getTestFramework().getOptions(), retryTestFramework.getOptions());
                return retryTestFramework;
            }

            private static JUnitTestFramework newInstance(Test task, DefaultTestFilter failedTestsFilter) {
                try {
                    Class<JUnitTestFramework> jUnitTestFrameworkClass = JUnitTestFramework.class;
                    Constructor constructor = jUnitTestFrameworkClass.getConstructor(Test.class, DefaultTestFilter.class);
                    return (JUnitTestFramework)constructor.newInstance(task, failedTestsFilter);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }

            private static void copyOptions(JUnitOptions source, JUnitOptions target) {
                target.setIncludeCategories(source.getIncludeCategories());
                target.setExcludeCategories(source.getExcludeCategories());
            }
        }
    }
}

