/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.config;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.testretry.TestRetryTaskExtension;

public class DefaultTestRetryTaskExtension
implements TestRetryTaskExtension {
    private final Property<Boolean> failOnPassedAfterRetry;
    private final Property<Integer> maxRetries;
    private final Property<Integer> maxFailures;
    private final TestRetryTaskExtension.Filter filter;
    private final TestRetryTaskExtension.ClassRetryCriteria classRetryCriteria;

    @Inject
    public DefaultTestRetryTaskExtension(ObjectFactory objects) {
        this.failOnPassedAfterRetry = objects.property(Boolean.class);
        this.maxRetries = objects.property(Integer.class);
        this.maxFailures = objects.property(Integer.class);
        this.filter = new FilterImpl(objects);
        this.classRetryCriteria = new ClassRetryCriteriaImpl(objects);
    }

    @Override
    public Property<Boolean> getFailOnPassedAfterRetry() {
        return this.failOnPassedAfterRetry;
    }

    @Override
    public Property<Integer> getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public Property<Integer> getMaxFailures() {
        return this.maxFailures;
    }

    @Override
    public void filter(Action<? super TestRetryTaskExtension.Filter> action) {
        action.execute((Object)this.filter);
    }

    @Override
    public TestRetryTaskExtension.Filter getFilter() {
        return this.filter;
    }

    @Override
    public TestRetryTaskExtension.ClassRetryCriteria getClassRetry() {
        return this.classRetryCriteria;
    }

    @Override
    public void classRetry(Action<? super TestRetryTaskExtension.ClassRetryCriteria> action) {
        action.execute((Object)this.classRetryCriteria);
    }

    private static final class ClassRetryCriteriaImpl
    implements TestRetryTaskExtension.ClassRetryCriteria {
        private final SetProperty<String> includeClasses;
        private final SetProperty<String> includeAnnotationClasses;

        public ClassRetryCriteriaImpl(ObjectFactory objects) {
            this.includeClasses = objects.setProperty(String.class);
            this.includeAnnotationClasses = objects.setProperty(String.class);
        }

        @Override
        public SetProperty<String> getIncludeClasses() {
            return this.includeClasses;
        }

        @Override
        public SetProperty<String> getIncludeAnnotationClasses() {
            return this.includeAnnotationClasses;
        }
    }

    private static final class FilterImpl
    implements TestRetryTaskExtension.Filter {
        private final SetProperty<String> includeClasses;
        private final SetProperty<String> includeAnnotationClasses;
        private final SetProperty<String> excludeClasses;
        private final SetProperty<String> excludeAnnotationClasses;

        public FilterImpl(ObjectFactory objects) {
            this.includeClasses = objects.setProperty(String.class);
            this.includeAnnotationClasses = objects.setProperty(String.class);
            this.excludeClasses = objects.setProperty(String.class);
            this.excludeAnnotationClasses = objects.setProperty(String.class);
        }

        @Override
        public SetProperty<String> getIncludeClasses() {
            return this.includeClasses;
        }

        @Override
        public SetProperty<String> getIncludeAnnotationClasses() {
            return this.includeAnnotationClasses;
        }

        @Override
        public SetProperty<String> getExcludeClasses() {
            return this.excludeClasses;
        }

        @Override
        public SetProperty<String> getExcludeAnnotationClasses() {
            return this.excludeAnnotationClasses;
        }
    }
}

