/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.internal.Cast;
import org.gradle.api.internal.Transformers;
import org.gradle.api.specs.Spec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionUtils {
    public static <T> T findFirst(Iterable<? extends T> source, Spec<? super T> filter) {
        for (T item : source) {
            if (!filter.isSatisfiedBy(item)) continue;
            return item;
        }
        return null;
    }

    public static <T> T findFirst(T[] source, Spec<? super T> filter) {
        for (T thing : source) {
            if (!filter.isSatisfiedBy(thing)) continue;
            return thing;
        }
        return null;
    }

    public static <T> boolean any(Iterable<? extends T> source, Spec<? super T> filter) {
        return CollectionUtils.findFirst(source, filter) != null;
    }

    public static <T> boolean any(T[] source, Spec<? super T> filter) {
        return CollectionUtils.findFirst(source, filter) != null;
    }

    public static <T> Set<T> filter(Set<? extends T> set, Spec<? super T> filter) {
        return CollectionUtils.filter(set, new LinkedHashSet(), filter);
    }

    public static <T> List<T> filter(List<? extends T> list, Spec<? super T> filter) {
        return CollectionUtils.filter(list, new LinkedList(), filter);
    }

    public static <T> List<T> sort(Iterable<? extends T> things, Comparator<? super T> comparator) {
        List<? extends T> copy = things instanceof Collection ? new ArrayList<T>((Collection)things) : CollectionUtils.toList(things);
        Collections.sort(copy, comparator);
        return copy;
    }

    public static <T, C extends Collection<T>> C filter(Iterable<? extends T> source, C destination, Spec<? super T> filter) {
        for (T item : source) {
            if (!filter.isSatisfiedBy(item)) continue;
            destination.add(item);
        }
        return destination;
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Spec<Map.Entry<K, V>> filter) {
        return CollectionUtils.filter(map, new HashMap(), filter);
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Map<K, V> destination, Spec<Map.Entry<K, V>> filter) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!filter.isSatisfiedBy(entry)) continue;
            destination.put(entry.getKey(), entry.getValue());
        }
        return destination;
    }

    public static <R, I> R[] collectArray(I[] list, Class<R> newType, Transformer<? extends R, ? super I> transformer) {
        Object[] destination = (Object[])Array.newInstance(newType, list.length);
        return CollectionUtils.collectArray(list, destination, transformer);
    }

    public static <R, I> R[] collectArray(I[] list, R[] destination, Transformer<? extends R, ? super I> transformer) {
        assert (list.length <= destination.length);
        for (int i = 0; i < list.length; ++i) {
            destination[i] = transformer.transform(list[i]);
        }
        return destination;
    }

    public static <R, I> List<R> collect(List<? extends I> list, Transformer<? extends R, ? super I> transformer) {
        return CollectionUtils.collect(list, new ArrayList(list.size()), transformer);
    }

    public static <R, I> List<R> collect(I[] list, Transformer<? extends R, ? super I> transformer) {
        return CollectionUtils.collect(Arrays.asList(list), transformer);
    }

    public static <R, I> Set<R> collect(Set<? extends I> set, Transformer<? extends R, ? super I> transformer) {
        return CollectionUtils.collect(set, new HashSet(), transformer);
    }

    public static <R, I> List<R> collect(Iterable<? extends I> source, Transformer<? extends R, ? super I> transformer) {
        return CollectionUtils.collect(source, new LinkedList(), transformer);
    }

    public static <R, I, C extends Collection<R>> C collect(Iterable<? extends I> source, C destination, Transformer<? extends R, ? super I> transformer) {
        for (I item : source) {
            destination.add(transformer.transform(item));
        }
        return destination;
    }

    public static List<String> toStringList(Iterable<?> iterable) {
        return CollectionUtils.collect(iterable, new LinkedList(), Transformers.asString());
    }

    public static List<?> flattenToList(Object ... things) {
        return CollectionUtils.flattenToList(Object.class, things);
    }

    public static <T> List<T> flattenToList(Class<T> type, Object ... things) {
        if (things == null) {
            return Collections.singletonList(null);
        }
        if (things.length == 0) {
            return Collections.emptyList();
        }
        if (things.length == 1) {
            Object thing = things[0];
            if (thing == null) {
                return Collections.singletonList(null);
            }
            if (thing.getClass().isArray()) {
                Object[] thingArray = (Object[])thing;
                ArrayList<T> list = new ArrayList<T>(thingArray.length);
                for (Object thingThing : thingArray) {
                    list.addAll(CollectionUtils.flattenToList(type, thingThing));
                }
                return list;
            }
            if (thing instanceof Iterable) {
                Iterable iterableThing = (Iterable)thing;
                ArrayList<T> list = new ArrayList<T>();
                for (Object thingThing : iterableThing) {
                    list.addAll(CollectionUtils.flattenToList(type, thingThing));
                }
                return list;
            }
            return Collections.singletonList(Cast.cast(type, thing));
        }
        ArrayList<T> list = new ArrayList<T>();
        for (Object thing : things) {
            list.addAll(CollectionUtils.flattenToList(type, thing));
        }
        return list;
    }

    public static <T> List<T> toList(Iterable<? extends T> things) {
        if (things == null) {
            return new ArrayList(0);
        }
        if (things instanceof List) {
            List castThings = (List)things;
            return castThings;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T thing : things) {
            list.add(thing);
        }
        return list;
    }

    public static <T> List<T> toList(T[] things) {
        if (things == null || things.length == 0) {
            return new ArrayList(0);
        }
        ArrayList<T> list = new ArrayList<T>(things.length);
        for (T thing : things) {
            list.add(thing);
        }
        return list;
    }

    public static <T> Set<T> toSet(Iterable<? extends T> things) {
        if (things == null) {
            return new HashSet(0);
        }
        if (things instanceof Set) {
            Set castThings = (Set)things;
            return castThings;
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (T thing : things) {
            set.add(thing);
        }
        return set;
    }

    public static <E> List<E> compact(List<E> list) {
        boolean foundAtLeastOneNull = false;
        List<E> compacted = null;
        int i = 0;
        for (E element : list) {
            if (element == null) {
                if (!foundAtLeastOneNull) {
                    compacted = new ArrayList(list.size());
                    if (i > 0) {
                        compacted.addAll(list.subList(0, i));
                    }
                }
                foundAtLeastOneNull = true;
            } else if (foundAtLeastOneNull) {
                compacted.add(element);
            }
            ++i;
        }
        return foundAtLeastOneNull ? compacted : list;
    }

    public static <C extends Collection<String>> C stringize(Iterable<?> source, C destination) {
        return CollectionUtils.collect(source, destination, Transformers.asString());
    }

    public static List<String> stringize(List<?> source) {
        return CollectionUtils.stringize(source, new ArrayList(source.size()));
    }

    public static <E> boolean replace(List<E> list, Spec<? super E> filter, Transformer<? extends E, ? super E> transformer) {
        boolean replaced = false;
        int i = 0;
        for (E it : list) {
            if (filter.isSatisfiedBy(it)) {
                list.set(i, transformer.transform(it));
                replaced = true;
            }
            ++i;
        }
        return replaced;
    }

    public static <K, V> void collectMap(Map<K, V> destination, Iterable<? extends V> items, Transformer<? extends K, ? super V> keyGenerator) {
        for (V item : items) {
            destination.put(keyGenerator.transform(item), item);
        }
    }

    public static <K, V> Map<K, V> collectMap(Iterable<? extends V> items, Transformer<? extends K, ? super V> keyGenerator) {
        LinkedHashMap map = new LinkedHashMap();
        CollectionUtils.collectMap(map, items, keyGenerator);
        return map;
    }

    public static <T> boolean every(Iterable<? extends T> things, Spec<? super T> predicate) {
        for (T thing : things) {
            if (predicate.isSatisfiedBy(thing)) continue;
            return false;
        }
        return true;
    }

    public static <T> Collection<T> addAll(Collection<T> t1, Iterable<? extends T> t2) {
        for (T t : t2) {
            t1.add(t);
        }
        return t1;
    }

    public static <T> SetDiff<T> diffSetsBy(Set<? extends T> left, Set<? extends T> right, Transformer<?, T> compareBy) {
        if (left == null) {
            throw new NullPointerException("'left' set is null");
        }
        if (right == null) {
            throw new NullPointerException("'right' set is null");
        }
        SetDiff setDiff = new SetDiff();
        Map<?, T> indexedLeft = CollectionUtils.collectMap(left, compareBy);
        Map<?, T> indexedRight = CollectionUtils.collectMap(right, compareBy);
        for (Map.Entry<?, T> leftEntry : indexedLeft.entrySet()) {
            T rightValue = indexedRight.remove(leftEntry.getKey());
            if (rightValue == null) {
                setDiff.leftOnly.add(leftEntry.getValue());
                continue;
            }
            SetDiff.Pair pair = new SetDiff.Pair();
            pair.left = leftEntry.getValue();
            pair.right = rightValue;
            setDiff.common.add(pair);
        }
        for (Map.Entry<?, ? extends T> rightValue : indexedRight.values()) {
            setDiff.rightOnly.add(rightValue);
        }
        return setDiff;
    }

    public static String join(String separator, Object[] objects) {
        return CollectionUtils.join(separator, objects == null ? null : Arrays.asList(objects));
    }

    public static String join(String separator, Iterable<?> objects) {
        if (separator == null) {
            throw new NullPointerException("The 'separator' cannot be null");
        }
        if (objects == null) {
            throw new NullPointerException("The 'objects' cannot be null");
        }
        boolean first = true;
        StringBuilder string = new StringBuilder();
        for (Object object : objects) {
            if (!first) {
                string.append(separator);
            }
            string.append(object.toString());
            first = false;
        }
        return string.toString();
    }

    public static <T, I> T inject(T target, Iterable<? extends I> items, Action<InjectionStep<T, I>> action) {
        if (target == null) {
            throw new NullPointerException("The 'target' cannot be null");
        }
        if (items == null) {
            throw new NullPointerException("The 'items' cannot be null");
        }
        if (action == null) {
            throw new NullPointerException("The 'action' cannot be null");
        }
        for (I item : items) {
            action.execute(new InjectionStep<T, I>(target, item));
        }
        return target;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InjectionStep<T, I> {
        private final T target;
        private final I item;

        public InjectionStep(T target, I item) {
            this.target = target;
            this.item = item;
        }

        public T getTarget() {
            return this.target;
        }

        public I getItem() {
            return this.item;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetDiff<T> {
        public Set<T> leftOnly = new HashSet<T>();
        public Set<Pair<T>> common = new HashSet<Pair<T>>();
        public Set<T> rightOnly = new HashSet<T>();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Pair<T> {
            public T left;
            public T right;
        }
    }
}

