/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.hash;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.hash.HashValue;

public class HashUtil {
    public static HashValue createHash(String scriptText, String algorithm) {
        MessageDigest messageDigest = HashUtil.createMessageDigest(algorithm);
        messageDigest.update(scriptText.getBytes());
        return new HashValue(messageDigest.digest());
    }

    public static HashValue createHash(File file, String algorithm) {
        try {
            return HashUtil.createHash(new FileInputStream(file), algorithm);
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashValue createHash(InputStream instr, String algorithm) {
        MessageDigest messageDigest = HashUtil.createMessageDigest(algorithm);
        try {
            byte[] buffer = new byte[4096];
            try {
                int nread;
                while ((nread = instr.read(buffer)) >= 0) {
                    messageDigest.update(buffer, 0, nread);
                }
            }
            finally {
                instr.close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new HashValue(messageDigest.digest());
    }

    private static MessageDigest createMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    public static String createCompactMD5(String scriptText) {
        return HashUtil.createHash(scriptText, "MD5").asCompactString();
    }

    public static HashValue sha1(byte[] bytes) {
        return HashUtil.createHash(new ByteArrayInputStream(bytes), "SHA1");
    }

    public static HashValue sha1(InputStream inputStream) {
        return HashUtil.createHash(inputStream, "SHA1");
    }

    public static HashValue sha1(File file) {
        return HashUtil.createHash(file, "SHA1");
    }
}

