/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classpath.ClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClassPath
implements ClassPath,
Serializable {
    private final List<File> files = new ArrayList<File>();

    public DefaultClassPath(Iterable<File> files) {
        for (File file : files) {
            this.files.add(file);
        }
    }

    public DefaultClassPath(File ... files) {
        this(Arrays.asList(files));
    }

    public String toString() {
        return this.files.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.files.isEmpty();
    }

    @Override
    public Collection<URI> getAsURIs() {
        ArrayList<URI> urls = new ArrayList<URI>();
        for (File file : this.files) {
            urls.add(file.toURI());
        }
        return urls;
    }

    @Override
    public Collection<File> getAsFiles() {
        return this.files;
    }

    @Override
    public URL[] getAsURLArray() {
        Collection<URL> result = this.getAsURLs();
        return result.toArray(new URL[result.size()]);
    }

    @Override
    public Collection<URL> getAsURLs() {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : this.files) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }
        return urls;
    }

    @Override
    public ClassPath plus(ClassPath other) {
        if (this.files.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        return new DefaultClassPath(this.concat(this.files, other.getAsFiles()));
    }

    @Override
    public ClassPath plus(Collection<File> other) {
        if (other.isEmpty()) {
            return this;
        }
        return new DefaultClassPath(this.concat(this.files, other));
    }

    private Iterable<File> concat(List<File> files1, Collection<File> files2) {
        ArrayList<File> result = new ArrayList<File>();
        result.addAll(files1);
        result.addAll(files2);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultClassPath other = (DefaultClassPath)obj;
        return this.files.equals(other.files);
    }

    public int hashCode() {
        return this.files.hashCode();
    }
}

