/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.gradle.internal.classloader.ClassLoaderHierarchy;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.ClassLoaderVisitor;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.reflect.JavaReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringClassLoader
extends ClassLoader
implements ClassLoaderHierarchy {
    private static final Set<ClassLoader> SYSTEM_CLASS_LOADERS;
    private static final ClassLoader EXT_CLASS_LOADER;
    private static final Set<String> SYSTEM_PACKAGES;
    private final Set<String> packageNames = new HashSet<String>();
    private final Set<String> packagePrefixes = new HashSet<String>();
    private final Set<String> resourcePrefixes = new HashSet<String>();
    private final Set<String> resourceNames = new HashSet<String>();
    private final Set<String> classNames = new HashSet<String>();
    private final Set<String> disallowedClassNames = new HashSet<String>();

    public FilteringClassLoader(ClassLoader parent) {
        super(parent);
    }

    public FilteringClassLoader(ClassLoader parent, Spec spec) {
        super(parent);
        this.packageNames.addAll(spec.packageNames);
        this.packagePrefixes.addAll(spec.packagePrefixes);
        this.resourceNames.addAll(spec.resourceNames);
        this.resourcePrefixes.addAll(spec.resourcePrefixes);
        this.classNames.addAll(spec.classNames);
        this.disallowedClassNames.addAll(spec.classNames);
    }

    @Override
    public void visit(ClassLoaderVisitor visitor) {
        visitor.visitSpec(new Spec(this.classNames, this.packageNames, this.packagePrefixes, this.resourcePrefixes, this.resourceNames, this.disallowedClassNames));
        visitor.visitParent(this.getParent());
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cl;
        try {
            cl = super.loadClass(name, false);
        }
        catch (NoClassDefFoundError e) {
            if (this.classAllowed(name)) {
                throw e;
            }
            throw new ClassNotFoundException(String.format("%s not found.", name));
        }
        if (!this.allowed(cl)) {
            throw new ClassNotFoundException(String.format("%s not found.", cl.getName()));
        }
        if (resolve) {
            this.resolveClass(cl);
        }
        return cl;
    }

    @Override
    protected Package getPackage(String name) {
        Package p = super.getPackage(name);
        if (p == null || !this.allowed(p)) {
            return null;
        }
        return p;
    }

    @Override
    protected Package[] getPackages() {
        ArrayList<Package> packages = new ArrayList<Package>();
        for (Package p : super.getPackages()) {
            if (!this.allowed(p)) continue;
            packages.add(p);
        }
        return packages.toArray(new Package[packages.size()]);
    }

    @Override
    public URL getResource(String name) {
        if (this.allowed(name)) {
            return super.getResource(name);
        }
        return EXT_CLASS_LOADER.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.allowed(name)) {
            return super.getResources(name);
        }
        return EXT_CLASS_LOADER.getResources(name);
    }

    private boolean allowed(String resourceName) {
        if (this.resourceNames.contains(resourceName)) {
            return true;
        }
        for (String resourcePrefix : this.resourcePrefixes) {
            if (!resourceName.startsWith(resourcePrefix)) continue;
            return true;
        }
        return false;
    }

    private boolean allowed(Package pkg) {
        if (SYSTEM_PACKAGES.contains(pkg.getName())) {
            return true;
        }
        if (this.packageNames.contains(pkg.getName())) {
            return true;
        }
        for (String packagePrefix : this.packagePrefixes) {
            if (!pkg.getName().startsWith(packagePrefix)) continue;
            return true;
        }
        return false;
    }

    private boolean allowed(final Class<?> clazz) {
        boolean systemClass = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return clazz.getClassLoader() == null || SYSTEM_CLASS_LOADERS.contains(clazz.getClassLoader());
            }
        });
        return systemClass || this.classAllowed(clazz.getName());
    }

    private boolean classAllowed(String className) {
        if (this.disallowedClassNames.contains(className)) {
            return false;
        }
        if (this.classNames.contains(className)) {
            return true;
        }
        for (String packagePrefix : this.packagePrefixes) {
            if (!className.startsWith(packagePrefix)) continue;
            return true;
        }
        return false;
    }

    public void allowPackage(String packageName) {
        this.packageNames.add(packageName);
        this.packagePrefixes.add(packageName + ".");
        this.resourcePrefixes.add(packageName.replace('.', '/') + '/');
    }

    public void allowClass(Class<?> clazz) {
        this.classNames.add(clazz.getName());
    }

    public void disallowClass(String className) {
        this.disallowedClassNames.add(className);
    }

    public void allowResources(String resourcePrefix) {
        this.resourcePrefixes.add(resourcePrefix + "/");
    }

    public void allowResource(String resourceName) {
        this.resourceNames.add(resourceName);
    }

    static {
        Package[] systemPackages;
        SYSTEM_CLASS_LOADERS = new HashSet<ClassLoader>();
        SYSTEM_PACKAGES = new HashSet<String>();
        for (ClassLoader cl = EXT_CLASS_LOADER = ClassLoader.getSystemClassLoader().getParent(); cl != null; cl = cl.getParent()) {
            SYSTEM_CLASS_LOADERS.add(cl);
        }
        JavaMethod<Class<ClassLoader>, Package[]> method = JavaReflectionUtil.method(ClassLoader.class, Package[].class, "getPackages", new Class[0]);
        for (Package p : systemPackages = method.invoke((Class<ClassLoader>)((Object)EXT_CLASS_LOADER), new Object[0])) {
            SYSTEM_PACKAGES.add(p.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Spec
    extends ClassLoaderSpec {
        final Set<String> packageNames;
        final Set<String> packagePrefixes;
        final Set<String> resourcePrefixes;
        final Set<String> resourceNames;
        final Set<String> classNames;
        final Set<String> disallowedClassNames;

        public Spec(Set<String> classNames, Set<String> packageNames, Set<String> packagePrefixes, Set<String> resourcePrefixes, Set<String> resourceNames, Set<String> disallowedClassNames) {
            this.classNames = new HashSet<String>(classNames);
            this.packageNames = new HashSet<String>(packageNames);
            this.packagePrefixes = new HashSet<String>(packagePrefixes);
            this.resourcePrefixes = new HashSet<String>(resourcePrefixes);
            this.resourceNames = new HashSet<String>(resourceNames);
            this.disallowedClassNames = new HashSet<String>(disallowedClassNames);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Spec other = (Spec)obj;
            return other.packageNames.equals(this.packageNames) && other.packagePrefixes.equals(this.packagePrefixes) && other.resourceNames.equals(this.resourceNames) && other.resourcePrefixes.equals(this.resourcePrefixes) && other.classNames.equals(this.classNames) && other.disallowedClassNames.equals(this.disallowedClassNames);
        }

        public int hashCode() {
            return this.packageNames.hashCode() ^ this.packagePrefixes.hashCode() ^ this.resourceNames.hashCode() ^ this.resourcePrefixes.hashCode() ^ this.classNames.hashCode() ^ this.disallowedClassNames.hashCode();
        }
    }
}

