/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.ClassLoaderVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathUtil {
    public static void addUrl(URLClassLoader classLoader, Iterable<URL> classpathElements) {
        try {
            HashSet<URI> original = new HashSet<URI>();
            for (URL url : classLoader.getURLs()) {
                original.add(url.toURI());
            }
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            for (URL classpathElement : classpathElements) {
                if (!original.add(classpathElement.toURI())) continue;
                method.invoke((Object)classLoader, classpathElement);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(String.format("Could not add URLs %s to class path for ClassLoader %s", classpathElements, classLoader), t);
        }
    }

    public static List<URL> getClasspath(ClassLoader classLoader) {
        final ArrayList<URL> implementationClassPath = new ArrayList<URL>();
        new ClassLoaderVisitor(){

            public void visitClassPath(URL[] classPath) {
                implementationClassPath.addAll(Arrays.asList(classPath));
            }
        }.visit(classLoader);
        return implementationClassPath;
    }

    public static File getClasspathForClass(Class<?> targetClass) {
        URI location;
        try {
            location = targetClass.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        if (!location.getScheme().equals("file")) {
            throw new GradleException(String.format("Cannot determine classpath for %s from codebase '%s'.", targetClass.getName(), location));
        }
        return new File(location.getPath());
    }

    public static File getClasspathForResource(ClassLoader classLoader, String name) {
        if (classLoader == null) {
            return ClasspathUtil.getClasspathForResource(ClassLoader.getSystemResource(name), name);
        }
        return ClasspathUtil.getClasspathForResource(classLoader.getResource(name), name);
    }

    public static File getClasspathForResource(URL resource, String name) {
        URI location;
        try {
            String schemeSpecificPart;
            int pos;
            location = resource.toURI();
            String path = location.getPath();
            if (location.getScheme().equals("file")) {
                assert (path.endsWith("/" + name));
                return new File(path.substring(0, path.length() - (name.length() + 1)));
            }
            if (location.getScheme().equals("jar") && (pos = (schemeSpecificPart = location.getRawSchemeSpecificPart()).indexOf("!")) > 0) {
                assert (schemeSpecificPart.substring(pos + 1).equals("/" + name));
                URI jarFile = new URI(schemeSpecificPart.substring(0, pos));
                if (jarFile.getScheme().equals("file")) {
                    return new File(jarFile.getPath());
                }
            }
        }
        catch (URISyntaxException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        throw new GradleException(String.format("Cannot determine classpath for resource '%s' from location '%s'.", name, location));
    }
}

