/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.github.dependencygraph;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.dependencygraph.DependencyGraphRenderer;
import org.gradle.dependencygraph.model.BuildLayout;
import org.gradle.dependencygraph.model.ResolvedConfiguration;
import org.gradle.dependencygraph.util.JacksonJsonSerializer;
import org.gradle.dependencygraph.util.PluginParameters;
import org.gradle.github.dependencygraph.GitHubRepositorySnapshotBuilder;
import org.gradle.github.dependencygraph.GitHubSnapshotParams;
import org.gradle.github.dependencygraph.model.GitHubManifest;
import org.gradle.github.dependencygraph.model.GitHubRepositorySnapshot;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/gradle/github/dependencygraph/GitHubDependencyGraphRenderer;", "Lorg/gradle/dependencygraph/DependencyGraphRenderer;", "()V", "outputDependencyGraph", "", "pluginParameters", "Lorg/gradle/dependencygraph/util/PluginParameters;", "buildLayout", "Lorg/gradle/dependencygraph/model/BuildLayout;", "resolvedConfigurations", "", "Lorg/gradle/dependencygraph/model/ResolvedConfiguration;", "outputDirectory", "Ljava/io/File;", "writeDependencySnapshot", "graph", "Lorg/gradle/github/dependencygraph/model/GitHubRepositorySnapshot;", "manifestFile", "Companion", "plugin"})
public final class GitHubDependencyGraphRenderer
implements DependencyGraphRenderer {
    private static final Logger LOGGER;
    @NotNull
    public static final Companion Companion;

    @Override
    public void outputDependencyGraph(@NotNull PluginParameters pluginParameters, @NotNull BuildLayout buildLayout, @NotNull List<ResolvedConfiguration> resolvedConfigurations, @NotNull File outputDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)pluginParameters, (String)"pluginParameters");
        Intrinsics.checkParameterIsNotNull((Object)buildLayout, (String)"buildLayout");
        Intrinsics.checkParameterIsNotNull(resolvedConfigurations, (String)"resolvedConfigurations");
        Intrinsics.checkParameterIsNotNull((Object)outputDirectory, (String)"outputDirectory");
        GitHubSnapshotParams snapshotParams = new GitHubSnapshotParams(pluginParameters);
        GitHubRepositorySnapshotBuilder gitHubRepositorySnapshotBuilder = new GitHubRepositorySnapshotBuilder(snapshotParams);
        String manifestName = snapshotParams.getDependencyGraphJobCorrelator();
        GitHubManifest manifest = gitHubRepositorySnapshotBuilder.buildManifest(manifestName, resolvedConfigurations, buildLayout);
        GitHubRepositorySnapshot snapshot = gitHubRepositorySnapshotBuilder.buildSnapshot(manifest);
        File outputFile = new File(outputDirectory, snapshotParams.getDependencyGraphJobCorrelator() + ".json");
        this.writeDependencySnapshot(snapshot, outputFile);
        String githubOutput = System.getenv("GITHUB_OUTPUT");
        if (githubOutput != null && new File(githubOutput).isFile()) {
            FilesKt.appendText$default((File)new File(githubOutput), (String)("dependency-graph-file=" + outputFile.getAbsolutePath() + '\n'), null, (int)2, null);
        }
    }

    private final void writeDependencySnapshot(GitHubRepositorySnapshot graph, File manifestFile) {
        FilesKt.writeText$default((File)manifestFile, (String)JacksonJsonSerializer.INSTANCE.serializeToJson(graph), null, (int)2, null);
        LOGGER.lifecycle("\nGitHubDependencyGraphRenderer: Wrote dependency snapshot to \n" + manifestFile.getCanonicalPath());
    }

    static {
        Companion = new Companion(null);
        LOGGER = Logging.getLogger(GitHubDependencyGraphRenderer.class);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gradle/github/dependencygraph/GitHubDependencyGraphRenderer$Companion;", "", "()V", "LOGGER", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

