/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.util;

import org.graalvm.wasm.WasmType;

public class ExtraDataUtil {
    private static final int EXTENDED_FORMAT_INDICATOR = Integer.MIN_VALUE;
    private static final int MIN_SIGNED_31BIT_VALUE = -1073741824;
    private static final int MAX_SIGNED_31BIT_VALUE = 0x3FFFFFFF;
    private static final int MAX_UNSIGNED_15BIT_VALUE = Short.MAX_VALUE;
    private static final int MIN_SIGNED_15BIT_VALUE = -16384;
    private static final int MAX_SIGNED_15BIT_VALUE = 16383;
    private static final int MAX_UNSIGNED_7BIT_VALUE = 127;
    public static final int COMPACT_JUMP_TARGET_SIZE = 1;
    public static final int COMPACT_STACK_CHANGE_SIZE = 1;
    public static final int COMPACT_CALL_TARGET_SIZE = 1;
    public static final int COMPACT_TABLE_HEADER_SIZE = 1;
    public static final int EXTENDED_JUMP_TARGET_SIZE = 2;
    public static final int EXTENDED_STACK_CHANGE_SIZE = 3;
    public static final int EXTENDED_CALL_TARGET_SIZE = 1;
    public static final int EXTENDED_TABLE_HEADER_SIZE = 1;
    public static final int PROFILE_SIZE = 1;
    private static final int PRIMITIVE_UNWIND = 0x800000;
    private static final int REFERENCE_UNWIND = Integer.MIN_VALUE;

    private static int createCompactShortValuesWithIndicator(int upperValue, int lowerValue) {
        return (upperValue << 16 | lowerValue) & Integer.MAX_VALUE;
    }

    private static int createCompactUpperBytes(int leadValue, int upperValue, int lowerValue) {
        return leadValue | upperValue << 24 | lowerValue << 16;
    }

    public static boolean isValidUnwindType(int value) {
        return value == 0 || value == 0x800000 || value == Integer.MIN_VALUE || value == -2139095040;
    }

    public static boolean exceedsUnsigned7BitValue(int value) {
        return Integer.compareUnsigned(value, 127) > 0;
    }

    public static boolean exceedsUnsignedShortValueWithIndicator(int value) {
        return Integer.compareUnsigned(value, Short.MAX_VALUE) > 0;
    }

    public static boolean exceedsSignedShortValueWithIndicator(int value) {
        return value < -16384 || 16383 < value;
    }

    public static boolean exceedsSignedShortValue(int value) {
        return value < Short.MIN_VALUE || Short.MAX_VALUE < value;
    }

    public static boolean exceedsUnsignedIntValueWithIndicator(int value) {
        return value < 0;
    }

    public static boolean exceedsSignedIntValueWithIndicator(int value) {
        return value < -1073741824 || 0x3FFFFFFF < value;
    }

    public static boolean exceedsPositiveIntValue(int value) {
        return value < 0;
    }

    public static int addCompactBranchTarget(int[] extraData, int branchTargetOffset, int byteCodeDisplacement, int extraDataDisplacement) {
        extraData[branchTargetOffset] = ExtraDataUtil.createCompactShortValuesWithIndicator(extraDataDisplacement, byteCodeDisplacement);
        return 1;
    }

    public static int addExtendedBranchTarget(int[] extraData, int branchTargetOffset, int byteCodeDisplacement, int extraDataDisplacement) {
        extraData[branchTargetOffset] = extraDataDisplacement | Integer.MIN_VALUE;
        extraData[branchTargetOffset + 1] = byteCodeDisplacement;
        return 2;
    }

    public static int addCompactStackChange(int[] extraData, int stackChangeOffset, int unwindType, int resultCount, int stackSize) {
        extraData[stackChangeOffset] = ExtraDataUtil.createCompactUpperBytes(unwindType, resultCount, stackSize);
        return 1;
    }

    public static int addExtendedStackChange(int[] extraData, int stackChangeOffset, int unwindType, int resultCount, int stackSize) {
        extraData[stackChangeOffset] = unwindType;
        extraData[stackChangeOffset + 1] = resultCount;
        extraData[stackChangeOffset + 2] = stackSize;
        return 3;
    }

    public static int addCompactCallTarget(int[] extraData, int callTargetOffset, int nodeIndex) {
        extraData[callTargetOffset] = ExtraDataUtil.createCompactShortValuesWithIndicator(nodeIndex, 0);
        return 1;
    }

    public static int addExtendedCallTarget(int[] extraData, int callTargetOffset, int nodeIndex) {
        extraData[callTargetOffset] = nodeIndex | Integer.MIN_VALUE;
        return 1;
    }

    public static int addCompactTableHeader(int[] extraData, int tableOffset, int size) {
        extraData[tableOffset] = ExtraDataUtil.createCompactShortValuesWithIndicator(size, 0);
        return 1;
    }

    public static int addExtendedTableHeader(int[] extraData, int tableOffset, int size) {
        extraData[tableOffset] = size | Integer.MIN_VALUE;
        return 1;
    }

    public static int addProfileCounter(int[] extraData, int profileOffset) {
        return 1;
    }

    public static int extractUnwindType(byte[] types) {
        int unwindType = 0;
        for (byte type : types) {
            unwindType |= WasmType.isNumberType(type) ? 0x800000 : 0;
            unwindType |= WasmType.isReferenceType(type) ? Integer.MIN_VALUE : 0;
        }
        return unwindType;
    }
}

