/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi.types;

import com.oracle.truffle.api.nodes.Node;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.memory.WasmMemoryLibrary;
import org.graalvm.wasm.predefined.wasi.types.Clockid;

public final class SubscriptionClock {
    public static final int BYTES = 32;

    private SubscriptionClock() {
    }

    public static Clockid readId(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address) {
        return Clockid.fromValue(memoryLib.load_i32(memory, node, address + 0));
    }

    public static void writeId(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address, Clockid value) {
        memoryLib.store_i32(memory, node, address + 0, value.toValue());
    }

    public static long readTimeout(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address) {
        return memoryLib.load_i64(memory, node, address + 8);
    }

    public static void writeTimeout(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address, long value) {
        memoryLib.store_i64(memory, node, address + 8, value);
    }

    public static long readPrecision(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address) {
        return memoryLib.load_i64(memory, node, address + 16);
    }

    public static void writePrecision(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address, long value) {
        memoryLib.store_i64(memory, node, address + 16, value);
    }

    public static short readFlags(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address) {
        return (short)memoryLib.load_i32_16u(memory, node, address + 24);
    }

    public static void writeFlags(Node node, WasmMemoryLibrary memoryLib, WasmMemory memory, int address, short value) {
        memoryLib.store_i32_16(memory, node, address + 24, value);
    }
}

