/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.Map;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.predefined.WasmBuiltinRootNode;
import org.graalvm.wasm.predefined.wasi.types.Errno;

public final class WasiEnvironSizesGetNode
extends WasmBuiltinRootNode {
    public WasiEnvironSizesGetNode(WasmLanguage language, WasmModule module) {
        super(language, module);
    }

    @Override
    public Object executeWithInstance(VirtualFrame frame, WasmInstance instance) {
        Object[] args = frame.getArguments();
        return this.environSizesGet(this.getContext(), this.memory(frame), (Integer)WasmArguments.getArgument(args, 0), (Integer)WasmArguments.getArgument(args, 1));
    }

    @CompilerDirectives.TruffleBoundary
    private int environSizesGet(WasmContext context, WasmMemory memory, int environCountAddress, int environSizeAddress) {
        Map env = context.environment().getEnvironment();
        int size = 0;
        for (Map.Entry entry : env.entrySet()) {
            size += WasmMemory.encodedStringLength((String)entry.getKey() + "=" + (String)entry.getValue());
            ++size;
        }
        this.memoryLib.store_i32(memory, (Node)this, environCountAddress, env.size());
        this.memoryLib.store_i32(memory, (Node)this, environSizeAddress, size);
        return Errno.Success.ordinal();
    }

    @Override
    public String builtinNodeName() {
        return "__wasi_environ_sizes_get";
    }
}

