/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.parser.bytecode;

import org.graalvm.wasm.api.Vector128;
import org.graalvm.wasm.collection.ByteArrayList;

public class BytecodeGen {
    private final ByteArrayList data = new ByteArrayList();

    public void addBytes(byte[] src, int srcOffset, int length) {
        this.data.addRange(src, srcOffset, length);
    }

    public void add(byte value) {
        this.add1(value);
    }

    public void add(int value) {
        this.add4(value);
    }

    public void allocate(int size) {
        this.data.allocate(size);
    }

    protected void add1(int value) {
        this.data.add((byte)value);
    }

    protected void add1(long value) {
        this.data.add((byte)value);
    }

    protected void add2(int value) {
        this.data.add((byte)(value & 0xFF));
        this.data.add((byte)(value >>> 8 & 0xFF));
    }

    protected void add2(long value) {
        this.data.add((byte)(value & 0xFFL));
        this.data.add((byte)(value >>> 8 & 0xFFL));
    }

    protected void add4(int value) {
        this.data.add((byte)(value & 0xFF));
        this.data.add((byte)(value >>> 8 & 0xFF));
        this.data.add((byte)(value >>> 16 & 0xFF));
        this.data.add((byte)(value >>> 24 & 0xFF));
    }

    protected void add4(long value) {
        this.data.add((byte)(value & 0xFFL));
        this.data.add((byte)(value >>> 8 & 0xFFL));
        this.data.add((byte)(value >>> 16 & 0xFFL));
        this.data.add((byte)(value >>> 24 & 0xFFL));
    }

    protected void add8(long value) {
        this.data.add((byte)(value & 0xFFL));
        this.data.add((byte)(value >>> 8 & 0xFFL));
        this.data.add((byte)(value >>> 16 & 0xFFL));
        this.data.add((byte)(value >>> 24 & 0xFFL));
        this.data.add((byte)(value >>> 32 & 0xFFL));
        this.data.add((byte)(value >>> 40 & 0xFFL));
        this.data.add((byte)(value >>> 48 & 0xFFL));
        this.data.add((byte)(value >>> 56 & 0xFFL));
    }

    protected void add16(Vector128 value) {
        this.data.addRange(value.getBytes(), 0, 16);
    }

    protected void set(int location, byte value) {
        this.data.set(location, value);
    }

    public void set(int location, int value) {
        assert (this.location() > location + 3);
        this.data.set(location, (byte)(value & 0xFF));
        this.data.set(location + 1, (byte)(value >>> 8 & 0xFF));
        this.data.set(location + 2, (byte)(value >>> 16 & 0xFF));
        this.data.set(location + 3, (byte)(value >>> 24 & 0xFF));
    }

    public int location() {
        return this.data.size();
    }

    public byte[] toArray() {
        return this.data.toArray();
    }
}

