/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.memory;

import java.lang.reflect.Field;
import java.nio.ByteOrder;
import sun.misc.Unsafe;

final class UnsafeUtilities {
    private static final Unsafe unsafe = UnsafeUtilities.initUnsafe();

    private static Unsafe initUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafe.setAccessible(true);
                return (Unsafe)theUnsafe.get(Unsafe.class);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while trying to get Unsafe", e);
            }
        }
    }

    private UnsafeUtilities() {
    }

    static byte compareAndExchangeByte(long startAddress, long byteOffset, byte expected, byte x) {
        int fullWord;
        long wordOffset = byteOffset & 0xFFFFFFFFFFFFFFFCL;
        int shift = (int)(byteOffset & 3L) << 3;
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            shift = 24 - shift;
        }
        int mask = 255 << shift;
        int maskedExpected = (expected & 0xFF) << shift;
        int maskedX = (x & 0xFF) << shift;
        do {
            if (((fullWord = unsafe.getIntVolatile(null, startAddress + wordOffset)) & mask) == maskedExpected) continue;
            return (byte)((fullWord & mask) >> shift);
        } while (!unsafe.compareAndSwapInt(null, startAddress + wordOffset, fullWord, fullWord & ~mask | maskedX));
        return expected;
    }

    static short compareAndExchangeShort(long startAddress, long byteOffset, short expected, short x) {
        int fullWord;
        if ((byteOffset & 3L) == 3L) {
            throw new IllegalArgumentException("Update spans the word, not supported");
        }
        long wordOffset = byteOffset & 0xFFFFFFFFFFFFFFFCL;
        int shift = (int)(byteOffset & 3L) << 3;
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            shift = 16 - shift;
        }
        int mask = 65535 << shift;
        int maskedExpected = (expected & 0xFFFF) << shift;
        int maskedX = (x & 0xFFFF) << shift;
        do {
            if (((fullWord = unsafe.getIntVolatile(null, startAddress + wordOffset)) & mask) == maskedExpected) continue;
            return (short)((fullWord & mask) >> shift);
        } while (!unsafe.compareAndSwapInt(null, startAddress + wordOffset, fullWord, fullWord & ~mask | maskedX));
        return expected;
    }

    static int compareAndExchangeInt(long startAddress, long byteOffset, int expected, int x) throws IndexOutOfBoundsException {
        int fullWord;
        if ((byteOffset & 3L) != 0L) {
            throw new IllegalArgumentException("Update spans the word, not supported");
        }
        long wordOffset = byteOffset & 0xFFFFFFFFFFFFFFFCL;
        do {
            if ((fullWord = unsafe.getIntVolatile(null, startAddress + wordOffset)) == expected) continue;
            return fullWord;
        } while (!unsafe.compareAndSwapInt(null, startAddress + wordOffset, fullWord, x));
        return expected;
    }

    static long compareAndExchangeLong(long startAddress, long byteOffset, long expected, long x) throws IndexOutOfBoundsException {
        long fullWord;
        if ((byteOffset & 7L) != 0L) {
            throw new IllegalArgumentException("Update spans the word, not supported");
        }
        long wordOffset = byteOffset & 0xFFFFFFFFFFFFFFF8L;
        do {
            if ((fullWord = unsafe.getLongVolatile(null, startAddress + wordOffset)) == expected) continue;
            return fullWord;
        } while (!unsafe.compareAndSwapLong(null, startAddress + wordOffset, fullWord, x));
        return expected;
    }
}

