/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.exception;

import com.oracle.truffle.api.exception.AbstractTruffleException;
import org.graalvm.wasm.exception.ExceptionProvider;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.exception.WasmJsApiException;

final class ExceptionProviders {
    static final ExceptionProvider WASM_JS_API_EXCEPTION_PROVIDER = new ExceptionProvider(){

        @Override
        public AbstractTruffleException createTypeError(Failure failure, String message) {
            return new WasmJsApiException(WasmJsApiException.Kind.TypeError, message);
        }

        @Override
        public AbstractTruffleException formatTypeError(Failure failure, String format, Object ... args) {
            return WasmJsApiException.format(WasmJsApiException.Kind.TypeError, format, args);
        }

        @Override
        public AbstractTruffleException createLinkError(Failure failure, String message) {
            return new WasmJsApiException(WasmJsApiException.Kind.LinkError, message);
        }

        @Override
        public AbstractTruffleException formatLinkError(Failure failure, String format, Object ... args) {
            return WasmJsApiException.format(WasmJsApiException.Kind.LinkError, format, args);
        }
    };
    static final ExceptionProvider POLYGLOT_EXCEPTION_PROVIDER = new ExceptionProvider(){

        @Override
        public AbstractTruffleException createTypeError(Failure failure, String message) {
            return WasmException.create(failure, message);
        }

        @Override
        public AbstractTruffleException formatTypeError(Failure failure, String format, Object ... args) {
            return WasmException.format(failure, format, args);
        }

        @Override
        public AbstractTruffleException createLinkError(Failure failure, String message) {
            return WasmException.create(failure, message);
        }

        @Override
        public AbstractTruffleException formatLinkError(Failure failure, String format, Object ... args) {
            return WasmException.format(failure, format, args);
        }
    };

    private ExceptionProviders() {
    }
}

