/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.representation;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import java.math.BigInteger;

@ExportLibrary(value=InteropLibrary.class)
public class DebugPrimitiveValue
implements TruffleObject {
    private final String expression;

    public DebugPrimitiveValue(String expression) {
        this.expression = expression;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public boolean isBoolean() {
        return "true".equalsIgnoreCase(this.expression) || "false".equalsIgnoreCase(this.expression);
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public boolean asBoolean() {
        return Boolean.parseBoolean(this.expression);
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public boolean isNumber() {
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public boolean fitsInByte() {
        try {
            Byte.parseByte(this.expression);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public byte asByte() {
        try {
            return Byte.parseByte(this.expression);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public boolean fitsInShort() {
        try {
            Short.parseShort(this.expression);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public short asShort() {
        try {
            return Short.parseShort(this.expression);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public boolean fitsInInt() {
        try {
            Integer.parseInt(this.expression);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public int asInt() {
        try {
            return Integer.parseInt(this.expression);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public boolean fitsInLong() {
        try {
            Long.parseLong(this.expression);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public long asLong() {
        try {
            return Long.parseLong(this.expression);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public boolean fitsInFloat() {
        try {
            Float.parseFloat(this.expression);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public float asFloat() {
        try {
            return Float.parseFloat(this.expression);
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public boolean fitsInDouble() {
        try {
            Double.parseDouble(this.expression);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public double asDouble() {
        try {
            return Double.parseDouble(this.expression);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public boolean fitsInBigInteger() {
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public BigInteger asBigInteger() throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public boolean isString() {
        return !this.expression.isBlank();
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public String asString() {
        return this.expression;
    }
}

