/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.representation;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.debugging.DebugLocation;
import org.graalvm.wasm.debugging.data.DebugContext;
import org.graalvm.wasm.debugging.data.DebugObject;
import org.graalvm.wasm.debugging.data.DebugType;
import org.graalvm.wasm.debugging.representation.DebugDisplayValue;

@ExportLibrary(value=InteropLibrary.class)
public final class DebugArrayDisplayValue
extends DebugDisplayValue
implements TruffleObject {
    private final DebugContext context;
    private final DebugLocation location;
    private final DebugType array;
    private final String name;
    private final int dimension;
    private final int indexOffset;

    private DebugArrayDisplayValue(DebugContext context, String name, int dimension, int indexOffset, DebugLocation location, DebugType array) {
        assert (context != null) : "the context provided to a debug array display value must not be null";
        assert (location != null) : "the location provided to a debug array display value must not be null";
        assert (array != null) : "the array type provided to a debug array display value must not be null";
        this.context = context;
        this.dimension = dimension;
        this.indexOffset = indexOffset;
        this.location = location;
        this.array = array;
        this.name = name;
    }

    @CompilerDirectives.TruffleBoundary
    public static DebugArrayDisplayValue fromDebugObject(DebugObject object, DebugContext context, DebugLocation location) {
        return new DebugArrayDisplayValue(context, object.toString(), 0, 0, location, object);
    }

    @ExportMessage
    public boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    public Class<? extends TruffleLanguage<?>> getLanguage() {
        return WasmLanguage.class;
    }

    @ExportMessage
    public boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public long getArraySize() {
        return this.array.arrayDimensionSize(this.dimension);
    }

    @ExportMessage.Repeat(value={@ExportMessage, @ExportMessage(name="isArrayElementModifiable")})
    @CompilerDirectives.TruffleBoundary
    public boolean isArrayElementReadable(long index) {
        return index >= 0L && index < Math.max(this.getArraySize(), 255L);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public Object readArrayElement(long index) throws InvalidArrayIndexException {
        if (!this.isArrayElementReadable(index)) {
            throw InvalidArrayIndexException.create((long)index);
        }
        int offset = this.indexOffset + (int)index;
        if (this.dimension < this.array.arrayDimensionCount() - 1) {
            int dimensionLength = this.array.arrayDimensionSize(this.dimension + 1);
            return new DebugArrayDisplayValue(this.context, "", this.dimension + 1, offset * dimensionLength, this.location, this.array);
        }
        DebugObject object = this.array.readArrayElement(this.context, this.location, offset);
        return this.resolveDebugObject(object, this.context, this.location);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public boolean isArrayElementInsertable(long index) {
        return false;
    }

    @ExportMessage(limit="5")
    @CompilerDirectives.TruffleBoundary
    public void writeArrayElement(long index, Object value, @CachedLibrary(value="value") InteropLibrary lib) throws InvalidArrayIndexException {
        if (!this.isArrayElementReadable(index)) {
            throw InvalidArrayIndexException.create((long)index);
        }
        int offset = this.indexOffset + (int)index;
        DebugObject object = this.array.readArrayElement(this.context, this.location, offset);
        this.writeDebugObject(object, this.context, this.location, value, lib);
    }

    @ExportMessage
    Object toDisplayString(boolean allowSideEffects) {
        return this.name != null ? this.name : "";
    }
}

