/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.parser;

import org.graalvm.wasm.BinaryStreamParser;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.parser.bytecode.BytecodeGen;

public class DebugUtil {
    public static final String ABBREV_NAME = ".debug_abbrev";
    public static final String INFO_NAME = ".debug_info";
    public static final String LINE_NAME = ".debug_line";
    public static final String LOC_NAME = ".debug_loc";
    public static final String RANGES_NAME = ".debug_ranges";
    public static final String STR_NAME = ".debug_str";
    public static final int CUSTOM_DATA_SIZE = 48;
    private static final int ABBREV_OFFSET = 0;
    private static final int ABBREV_LENGTH_OFFSET = 4;
    private static final int INFO_OFFSET = 8;
    private static final int INFO_LENGTH_OFFSET = 12;
    private static final int LINE_OFFSET = 16;
    private static final int LINE_LENGTH_OFFSET = 20;
    private static final int LOC_OFFSET = 24;
    private static final int LOC_LENGTH_OFFSET = 28;
    private static final int RANGES_OFFSET = 32;
    private static final int RANGES_LENGTH_OFFSET = 36;
    private static final int STR_OFFSET = 40;
    private static final int STR_LENGTH_OFFSET = 44;
    public static final int DEFAULT_I32 = -1;
    public static final long DEFAULT_I64 = -1L;
    public static final int UNDEFINED = -1;

    public static void initializeData(BytecodeGen customData, int debugInfoOffset) {
        customData.set(debugInfoOffset + 0, -1);
        customData.set(debugInfoOffset + 4, -1);
        customData.set(debugInfoOffset + 8, -1);
        customData.set(debugInfoOffset + 12, -1);
        customData.set(debugInfoOffset + 16, -1);
        customData.set(debugInfoOffset + 20, -1);
        customData.set(debugInfoOffset + 24, -1);
        customData.set(debugInfoOffset + 28, -1);
        customData.set(debugInfoOffset + 32, -1);
        customData.set(debugInfoOffset + 36, -1);
        customData.set(debugInfoOffset + 40, -1);
        customData.set(debugInfoOffset + 44, -1);
    }

    public static void setAbbrevOffset(BytecodeGen customData, int debugInfoOffset, int offset, int length) {
        customData.set(debugInfoOffset + 0, offset);
        customData.set(debugInfoOffset + 4, length);
    }

    public static int getAbbrevOffsetOrUndefined(byte[] customData, int debugInfoOffset) {
        try {
            return BinaryStreamParser.rawPeekI32(customData, debugInfoOffset + 0);
        }
        catch (WasmException e) {
            return -1;
        }
    }

    public static int getAbbrevLengthOrUndefined(byte[] customData, int debugInfoOffset) {
        try {
            return BinaryStreamParser.rawPeekI32(customData, debugInfoOffset + 4);
        }
        catch (WasmException e) {
            return -1;
        }
    }

    public static void setInfo(BytecodeGen customData, int debugInfoOffset, int offset, int length) {
        customData.set(debugInfoOffset + 8, offset);
        customData.set(debugInfoOffset + 12, length);
    }

    public static int getInfoOffsetOrUndefined(byte[] customData, int debugInfoOffset) {
        try {
            return BinaryStreamParser.rawPeekI32(customData, debugInfoOffset + 8);
        }
        catch (WasmException e) {
            return -1;
        }
    }

    public static int getInfoLengthOrUndefined(byte[] customData, int debugInfoOffset) {
        try {
            return BinaryStreamParser.rawPeekI32(customData, debugInfoOffset + 12);
        }
        catch (WasmException e) {
            return -1;
        }
    }

    public static void setLineOffset(BytecodeGen customData, int debugInfoOffset, int offset, int length) {
        customData.set(debugInfoOffset + 16, offset);
        customData.set(debugInfoOffset + 20, length);
    }

    public static int getLineOffsetOrUndefined(byte[] customData, int debugInfoOffset) {
        try {
            return BinaryStreamParser.rawPeekI32(customData, debugInfoOffset + 16);
        }
        catch (WasmException e) {
            return -1;
        }
    }

    public static int getLineLengthOrUndefined(byte[] customData, int debugInfoOffset) {
        try {
            return BinaryStreamParser.rawPeekI32(customData, debugInfoOffset + 20);
        }
        catch (WasmException e) {
            return -1;
        }
    }

    public static void setLocOffset(BytecodeGen customData, int debugInfoOffset, int offset, int length) {
        customData.set(debugInfoOffset + 24, offset);
        customData.set(debugInfoOffset + 28, length);
    }

    public static int getLocOffsetOrUndefined(byte[] customData, int debugInfoOffset) {
        try {
            return BinaryStreamParser.rawPeekI32(customData, debugInfoOffset + 24);
        }
        catch (WasmException e) {
            return -1;
        }
    }

    public static int getLocLengthOrUndefined(byte[] customData, int debugInfoOffset) {
        try {
            return BinaryStreamParser.rawPeekI32(customData, debugInfoOffset + 28);
        }
        catch (WasmException e) {
            return -1;
        }
    }

    public static void setRangesOffset(BytecodeGen customDataGen, int debugInfoOffset, int offset, int length) {
        customDataGen.set(debugInfoOffset + 32, offset);
        customDataGen.set(debugInfoOffset + 36, length);
    }

    public static int getRangesOffsetOrUndefined(byte[] customData, int debugInfoOffset) {
        try {
            return BinaryStreamParser.rawPeekI32(customData, debugInfoOffset + 32);
        }
        catch (WasmException e) {
            return -1;
        }
    }

    public static int getRangesLengthOrUndefined(byte[] customData, int debugInfoOffset) {
        try {
            return BinaryStreamParser.rawPeekI32(customData, debugInfoOffset + 36);
        }
        catch (WasmException e) {
            return -1;
        }
    }

    public static void setStrOffset(BytecodeGen customData, int debugInfoOffset, int offset, int length) {
        customData.set(debugInfoOffset + 40, offset);
        customData.set(debugInfoOffset + 44, length);
    }

    public static int getStrOffsetOrUndefined(byte[] customData, int debugInfoOffset) {
        try {
            return BinaryStreamParser.rawPeekI32(customData, debugInfoOffset + 40);
        }
        catch (WasmException e) {
            return -1;
        }
    }

    public static int getStrLengthOrUndefined(byte[] customData, int debugInfoOffset) {
        try {
            return BinaryStreamParser.rawPeekI32(customData, debugInfoOffset + 44);
        }
        catch (WasmException e) {
            return -1;
        }
    }
}

