/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.data.types;

import com.oracle.truffle.api.interop.InteropLibrary;
import org.graalvm.wasm.debugging.DebugLocation;
import org.graalvm.wasm.debugging.data.DebugContext;
import org.graalvm.wasm.debugging.data.DebugObject;
import org.graalvm.wasm.debugging.data.DebugType;
import org.graalvm.wasm.debugging.parser.DebugParser;

public class DebugInheritance
extends DebugType {
    private final DebugType referenceType;
    private final byte[] locationExpression;
    private final int memberOffset;

    public DebugInheritance(DebugType referenceType, byte[] locationExpression, int memberOffset) {
        assert (referenceType != null) : "the reference type (super class) of a debug inheritance must not be null";
        this.referenceType = referenceType;
        this.locationExpression = locationExpression;
        this.memberOffset = memberOffset;
    }

    private DebugLocation offsetLocation(DebugLocation baseLocation) {
        if (this.locationExpression != null) {
            return DebugParser.readExpression(this.locationExpression, baseLocation);
        }
        return baseLocation.addOffset(this.memberOffset);
    }

    @Override
    public String asTypeName() {
        return this.referenceType.asTypeName();
    }

    @Override
    public int valueLength() {
        return this.referenceType.valueLength();
    }

    @Override
    public boolean isValue() {
        return this.referenceType.isValue();
    }

    @Override
    public Object asValue(DebugContext context, DebugLocation location) {
        return this.referenceType.asValue(context, this.offsetLocation(location));
    }

    @Override
    public boolean isModifiableValue() {
        return this.referenceType.isModifiableValue();
    }

    @Override
    public void setValue(DebugContext context, DebugLocation location, Object value, InteropLibrary lib) {
        this.referenceType.setValue(context, this.offsetLocation(location), value, lib);
    }

    @Override
    public boolean isDebugObject() {
        return this.referenceType.isDebugObject();
    }

    @Override
    public DebugObject asDebugObject(DebugContext context, DebugLocation location) {
        return this.referenceType.asDebugObject(context, this.offsetLocation(location));
    }

    @Override
    public boolean isLocation() {
        return this.referenceType.isLocation();
    }

    @Override
    public DebugLocation asLocation(DebugContext context, DebugLocation location) {
        return this.referenceType.asLocation(context, this.offsetLocation(location));
    }

    @Override
    public boolean fitsIntoInt() {
        return this.referenceType.fitsIntoInt();
    }

    @Override
    public int asInt(DebugContext context, DebugLocation location) {
        return this.referenceType.asInt(context, this.offsetLocation(location));
    }

    @Override
    public boolean fitsIntoLong() {
        return this.referenceType.fitsIntoLong();
    }

    @Override
    public long asLong(DebugContext context, DebugLocation location) {
        return this.referenceType.asLong(context, this.offsetLocation(location));
    }

    @Override
    public boolean hasMembers() {
        return this.referenceType.hasMembers();
    }

    @Override
    public int memberCount() {
        return this.referenceType.memberCount();
    }

    @Override
    public DebugObject readMember(DebugContext context, DebugLocation location, int index) {
        return this.referenceType.readMember(context, this.offsetLocation(location), index);
    }

    @Override
    public boolean hasArrayElements() {
        return this.referenceType.hasArrayElements();
    }

    @Override
    public int arrayDimensionCount() {
        return this.referenceType.arrayDimensionCount();
    }

    @Override
    public int arrayDimensionSize(int dimension) {
        return this.referenceType.arrayDimensionSize(dimension);
    }

    @Override
    public DebugObject readArrayElement(DebugContext context, DebugLocation location, int index) {
        return this.referenceType.readArrayElement(context, this.offsetLocation(location), index);
    }
}

