/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.data.objects;

import org.graalvm.wasm.debugging.DebugLocation;
import org.graalvm.wasm.debugging.data.DebugContext;
import org.graalvm.wasm.debugging.data.DebugType;
import org.graalvm.wasm.debugging.data.objects.DebugBinding;
import org.graalvm.wasm.debugging.parser.DebugParser;

public class DebugVariable
extends DebugBinding {
    private final String name;
    private final byte[] locationExpression;
    private final int startSourceLocation;
    private final int endSourceLocation;

    public DebugVariable(String name, DebugType type, byte[] locationExpression, int startSourceLocation, int endSourceLocation) {
        super(type);
        this.name = name;
        this.locationExpression = locationExpression;
        this.startSourceLocation = startSourceLocation;
        this.endSourceLocation = endSourceLocation;
    }

    private DebugLocation variableLocation(DebugLocation baseLocation) {
        if (this.locationExpression != null) {
            return DebugParser.readExpression(this.locationExpression, baseLocation);
        }
        return baseLocation.invalidate();
    }

    @Override
    public String toDisplayString() {
        return this.name;
    }

    @Override
    public boolean isVisible(int sourceCodeLocation) {
        return this.startSourceLocation < sourceCodeLocation && sourceCodeLocation < this.endSourceLocation;
    }

    @Override
    public DebugLocation getLocation(DebugLocation location) {
        return this.variableLocation(location);
    }

    @Override
    public DebugContext getContext(DebugContext context) {
        return context.with(this.name);
    }
}

