/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.data.objects;

import org.graalvm.wasm.debugging.DebugLocation;
import org.graalvm.wasm.debugging.data.DebugContext;
import org.graalvm.wasm.debugging.data.DebugType;
import org.graalvm.wasm.debugging.data.objects.DebugBinding;
import org.graalvm.wasm.debugging.parser.DebugParser;

public class DebugMember
extends DebugBinding {
    private final String name;
    private final byte[] locationExpression;
    private final int offset;
    private final int bitOffset;
    private final int bitSize;

    public DebugMember(String name, DebugType type, byte[] locationExpression, int offset, int bitOffset, int bitSize) {
        super(type);
        this.name = name;
        this.locationExpression = locationExpression;
        this.offset = offset;
        this.bitOffset = bitOffset;
        this.bitSize = bitSize;
    }

    private DebugLocation memberLocation(DebugLocation baseLocation) {
        if (this.locationExpression != null) {
            return DebugParser.readExpression(this.locationExpression, baseLocation);
        }
        return baseLocation.addOffset(this.offset);
    }

    @Override
    public String toDisplayString() {
        return this.name;
    }

    @Override
    public DebugLocation getLocation(DebugLocation location) {
        return this.memberLocation(location);
    }

    @Override
    public DebugContext getContext(DebugContext context) {
        return context.with(this.name, this.bitSize, this.bitOffset);
    }
}

