/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.utilities.FinalBitSet;
import org.graalvm.wasm.api.WasmModuleWithSource;

@GeneratedBy(value=WasmModuleWithSource.class)
final class WasmModuleWithSourceGen {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private WasmModuleWithSourceGen() {
    }

    static {
        LibraryExport.register(WasmModuleWithSource.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=WasmModuleWithSource.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        static final FinalBitSet ENABLED_MESSAGES = InteropLibraryExports.createMessageBitSet(INTEROP_LIBRARY_, (String[])new String[0]);
        private static final Uncached UNCACHED = new Uncached();

        private InteropLibraryExports() {
            super(InteropLibrary.class, WasmModuleWithSource.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof WasmModuleWithSource);
            InteropLibrary uncached = (InteropLibrary)InteropLibraryExports.createDelegate(INTEROP_LIBRARY_, (Library)UNCACHED);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof WasmModuleWithSource);
            return (InteropLibrary)InteropLibraryExports.createDelegate(INTEROP_LIBRARY_, (Library)new Cached(receiver));
        }

        @GeneratedBy(value=WasmModuleWithSource.class)
        @DenyReplace
        private static final class Uncached
        extends InteropLibrary
        implements LibraryExport.DelegateExport,
        UnadoptableNode {
            protected Uncached() {
            }

            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            public Object readDelegateExport(Object receiver_) {
                return ((WasmModuleWithSource)receiver_).module;
            }

            public Library getDelegateExportLibrary(Object delegate_) {
                return INTEROP_LIBRARY_.getUncached(delegate_);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof WasmModuleWithSource) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof WasmModuleWithSource;
            }
        }

        @GeneratedBy(value=WasmModuleWithSource.class)
        private static final class Cached
        extends InteropLibrary
        implements LibraryExport.DelegateExport {
            @Node.Child
            private InteropLibrary receiverModuleInteropLibrary_;

            protected Cached(Object receiver) {
                WasmModuleWithSource castReceiver = (WasmModuleWithSource)receiver;
                this.receiverModuleInteropLibrary_ = (InteropLibrary)INTEROP_LIBRARY_.create((Object)castReceiver.module);
            }

            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            public Object readDelegateExport(Object receiver_) {
                return ((WasmModuleWithSource)receiver_).module;
            }

            public Library getDelegateExportLibrary(Object delegate) {
                return this.receiverModuleInteropLibrary_;
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof WasmModuleWithSource) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof WasmModuleWithSource)) {
                    return false;
                }
                return this.receiverModuleInteropLibrary_.accepts((Object)((WasmModuleWithSource)receiver).module);
            }
        }
    }
}

