/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.api;

import com.oracle.truffle.api.CompilerAsserts;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;

public enum ValueType {
    i32(127),
    i64(126),
    f32(125),
    f64(124),
    v128(123),
    anyfunc(112),
    externref(111);

    private final byte byteValue;

    private ValueType(byte byteValue) {
        this.byteValue = byteValue;
    }

    public static ValueType fromByteValue(byte value) {
        CompilerAsserts.neverPartOfCompilation();
        switch (value) {
            case 127: {
                return i32;
            }
            case 126: {
                return i64;
            }
            case 125: {
                return f32;
            }
            case 124: {
                return f64;
            }
            case 123: {
                return v128;
            }
            case 112: {
                return anyfunc;
            }
            case 111: {
                return externref;
            }
        }
        throw WasmException.create(Failure.UNSPECIFIED_INTERNAL, null, "Unknown value type: 0x" + Integer.toHexString(value));
    }

    public byte byteValue() {
        return this.byteValue;
    }

    public static boolean isNumberType(ValueType valueType) {
        return valueType == i32 || valueType == i64 || valueType == f32 || valueType == f64;
    }

    public static boolean isVectorType(ValueType valueType) {
        return valueType == v128;
    }

    public static boolean isReferenceType(ValueType valueType) {
        return valueType == anyfunc || valueType == externref;
    }
}

