/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.api;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmConstant;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmFunction;
import org.graalvm.wasm.WasmFunctionInstance;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.api.Vector128;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;

public final class ExecuteHostFunctionNode
extends RootNode {
    private final WasmModule module;
    private final int functionTypeIndex;
    private final int functionIndex;
    private final BranchProfile errorBranch = BranchProfile.create();
    @Node.Child
    private InteropLibrary functionInterop;
    @Node.Child
    private InteropLibrary arrayInterop;
    @Node.Child
    private InteropLibrary resultInterop;

    public ExecuteHostFunctionNode(WasmLanguage language, WasmModule module, WasmFunction fn) {
        super((TruffleLanguage)language);
        this.module = module;
        this.functionTypeIndex = fn.typeIndex();
        this.functionIndex = fn.index();
        this.functionInterop = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);
        if (fn.resultCount() > 1) {
            this.arrayInterop = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);
        }
    }

    public Object execute(VirtualFrame frame) {
        assert (WasmArguments.isValid(frame.getArguments()));
        WasmInstance instance = WasmArguments.getModuleInstance(frame.getArguments());
        Object[] arguments = WasmArguments.getArguments(frame.getArguments());
        try {
            WasmFunctionInstance functionInstance = instance.functionInstance(this.functionIndex);
            assert (functionInstance.context() == WasmContext.get(null));
            Object executable = functionInstance.getImportedFunction();
            Object result = this.functionInterop.execute(executable, arguments);
            int resultCount = this.module.symbolTable().functionTypeResultCount(this.functionTypeIndex);
            CompilerAsserts.partialEvaluationConstant((int)resultCount);
            if (resultCount == 0) {
                return WasmConstant.VOID;
            }
            if (resultCount == 1) {
                byte resultType = this.module.symbolTable().functionTypeResultTypeAt(this.functionTypeIndex, 0);
                return this.convertResult(result, resultType);
            }
            this.pushMultiValueResult(result, resultCount);
            return WasmConstant.MULTI_VALUE;
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            this.errorBranch.enter();
            throw WasmException.format(Failure.UNSPECIFIED_TRAP, (Node)this, "Call failed: %s", (Object)ExecuteHostFunctionNode.getMessage((InteropException)e));
        }
    }

    private Object convertResult(Object result, byte resultType) throws UnsupportedMessageException {
        CompilerAsserts.partialEvaluationConstant((int)resultType);
        return switch (resultType) {
            case 127 -> this.asInt(result);
            case 126 -> this.asLong(result);
            case 125 -> Float.valueOf(this.asFloat(result));
            case 124 -> this.asDouble(result);
            case 111, 112, 123 -> result;
            default -> throw WasmException.format(Failure.UNSPECIFIED_TRAP, (Node)this, "Unknown result type: %d", resultType);
        };
    }

    @ExplodeLoop
    private void pushMultiValueResult(Object result, int resultCount) {
        CompilerAsserts.partialEvaluationConstant((int)resultCount);
        if (!this.arrayInterop.hasArrayElements(result)) {
            this.errorBranch.enter();
            throw WasmException.create(Failure.UNSUPPORTED_MULTI_VALUE_TYPE);
        }
        try {
            int size = (int)this.arrayInterop.getArraySize(result);
            if (size != resultCount) {
                this.errorBranch.enter();
                throw WasmException.create(Failure.INVALID_MULTI_VALUE_ARITY);
            }
            WasmLanguage.MultiValueStack multiValueStack = WasmLanguage.get((Node)this).multiValueStack();
            multiValueStack.resize(resultCount);
            long[] primitiveMultiValueStack = multiValueStack.primitiveStack();
            Object[] objectMultiValueStack = multiValueStack.objectStack();
            block10: for (int i = 0; i < resultCount; ++i) {
                byte resultType = this.module.symbolTable().functionTypeResultTypeAt(this.functionTypeIndex, i);
                CompilerAsserts.partialEvaluationConstant((int)resultType);
                Object value = this.arrayInterop.readArrayElement(result, (long)i);
                switch (resultType) {
                    case 127: {
                        primitiveMultiValueStack[i] = this.asInt(value);
                        continue block10;
                    }
                    case 126: {
                        primitiveMultiValueStack[i] = this.asLong(value);
                        continue block10;
                    }
                    case 125: {
                        primitiveMultiValueStack[i] = Float.floatToRawIntBits(this.asFloat(value));
                        continue block10;
                    }
                    case 124: {
                        primitiveMultiValueStack[i] = Double.doubleToRawLongBits(this.asDouble(value));
                        continue block10;
                    }
                    case 123: {
                        if (!(value instanceof Vector128)) {
                            this.errorBranch.enter();
                            throw WasmException.create(Failure.INVALID_TYPE_IN_MULTI_VALUE);
                        }
                        objectMultiValueStack[i] = value;
                        continue block10;
                    }
                    case 111: 
                    case 112: {
                        objectMultiValueStack[i] = value;
                        continue block10;
                    }
                    default: {
                        this.errorBranch.enter();
                        throw WasmException.format(Failure.UNSPECIFIED_TRAP, (Node)this, "Unknown result type: %d", resultType);
                    }
                }
            }
        }
        catch (InvalidArrayIndexException | UnsupportedMessageException e) {
            this.errorBranch.enter();
            throw WasmException.create(Failure.INVALID_TYPE_IN_MULTI_VALUE);
        }
    }

    private int asInt(Object result) throws UnsupportedMessageException {
        if (result instanceof Integer) {
            Integer i = (Integer)result;
            return i;
        }
        return this.resultInterop().asInt(result);
    }

    private long asLong(Object result) throws UnsupportedMessageException {
        if (result instanceof Long) {
            Long l = (Long)result;
            return l;
        }
        return this.resultInterop().asLong(result);
    }

    private float asFloat(Object result) throws UnsupportedMessageException {
        if (result instanceof Float) {
            Float f = (Float)result;
            return f.floatValue();
        }
        return this.resultInterop().asFloat(result);
    }

    private double asDouble(Object result) throws UnsupportedMessageException {
        if (result instanceof Double) {
            Double d = (Double)result;
            return d;
        }
        return this.resultInterop().asDouble(result);
    }

    private InteropLibrary resultInterop() {
        InteropLibrary interop = this.resultInterop;
        if (interop == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.resultInterop = interop = (InteropLibrary)this.insert((Node)((InteropLibrary)InteropLibrary.getFactory().createDispatched(5)));
        }
        return interop;
    }

    @CompilerDirectives.TruffleBoundary
    private static String getMessage(InteropException e) {
        return e.getMessage();
    }

    public String getName() {
        return "wasm-function:execute";
    }

    public String toString() {
        return this.getName();
    }

    protected boolean isInstrumentable() {
        return false;
    }
}

