/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import java.util.ArrayList;
import org.graalvm.wasm.SymbolTable;
import org.graalvm.wasm.WasmConstant;
import org.graalvm.wasm.WasmFunction;
import org.graalvm.wasm.WasmFunctionInstance;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.api.Sequence;

@ExportLibrary(value=InteropLibrary.class)
public final class WasmInstanceExports
implements TruffleObject {
    private final WasmInstance instance;

    public WasmInstanceExports(WasmInstance instance) {
        this.instance = instance;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public Object readMember(String member) throws UnknownIdentifierException {
        SymbolTable symbolTable = this.instance.symbolTable();
        WasmFunction function = (WasmFunction)symbolTable.exportedFunctions().get((Object)member);
        if (function != null) {
            return this.instance.functionInstance(function);
        }
        Integer tableIndex = (Integer)symbolTable.exportedTables().get((Object)member);
        if (tableIndex != null) {
            return this.instance.store().tables().table(this.instance.tableAddress(tableIndex));
        }
        Integer memoryIndex = (Integer)symbolTable.exportedMemories().get((Object)member);
        if (memoryIndex != null) {
            return this.instance.memory(memoryIndex);
        }
        Integer globalIndex = (Integer)symbolTable.exportedGlobals().get((Object)member);
        if (globalIndex != null) {
            return this.instance.externalGlobal(globalIndex);
        }
        throw UnknownIdentifierException.create((String)member);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberReadable(String member) {
        SymbolTable symbolTable = this.instance.symbolTable();
        return symbolTable.exportedFunctions().containsKey((Object)member) || symbolTable.exportedMemories().containsKey((Object)member) || symbolTable.exportedTables().containsKey((Object)member) || symbolTable.exportedGlobals().containsKey((Object)member);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberInvocable(String member) {
        SymbolTable symbolTable = this.instance.symbolTable();
        return symbolTable.exportedFunctions().containsKey((Object)member);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object invokeMember(String member, Object ... arguments) throws UnknownIdentifierException, UnsupportedMessageException, UnsupportedTypeException, ArityException {
        if (!this.isMemberInvocable(member)) {
            throw UnknownIdentifierException.create((String)member);
        }
        SymbolTable symbolTable = this.instance.symbolTable();
        WasmFunction function = (WasmFunction)symbolTable.exportedFunctions().get((Object)member);
        if (function != null) {
            WasmFunctionInstance functionInstance = this.instance.functionInstance(function);
            InteropLibrary lib = InteropLibrary.getUncached((Object)functionInstance);
            assert (lib.isExecutable((Object)functionInstance));
            return lib.execute((Object)functionInstance, arguments);
        }
        return WasmConstant.VOID;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMembers(boolean includeInternal) {
        SymbolTable symbolTable = this.instance.symbolTable();
        ArrayList<String> exportNames = new ArrayList<String>();
        for (String functionName : symbolTable.exportedFunctions().getKeys()) {
            exportNames.add(functionName);
        }
        for (String tableName : symbolTable.exportedTables().getKeys()) {
            exportNames.add(tableName);
        }
        for (String memoryName : symbolTable.exportedMemories().getKeys()) {
            exportNames.add(memoryName);
        }
        for (String globalName : symbolTable.exportedGlobals().getKeys()) {
            exportNames.add(globalName);
        }
        return new Sequence(exportNames);
    }

    public String toString() {
        return "wasm-instance-exports(" + this.instance.name() + ")";
    }
}

