/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.runtime.SLType;
import java.math.BigDecimal;
import java.math.BigInteger;

@ExportLibrary(value=InteropLibrary.class)
public final class SLBigInteger
implements TruffleObject,
Comparable<SLBigInteger> {
    private final BigInteger value;

    public SLBigInteger(BigInteger value) {
        this.value = value;
    }

    public SLBigInteger(long value) {
        this.value = BigInteger.valueOf(value);
    }

    public BigInteger getValue() {
        return this.value;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int compareTo(SLBigInteger o) {
        return this.value.compareTo(o.getValue());
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.value.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public boolean equals(Object obj) {
        if (obj instanceof SLBigInteger) {
            return this.value.equals(((SLBigInteger)obj).getValue());
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @ExportMessage
    boolean isNumber() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean fitsInByte() {
        return this.value.bitLength() < 8;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean fitsInShort() {
        return this.value.bitLength() < 16;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean fitsInFloat() {
        if (this.value.bitLength() <= 24) {
            return true;
        }
        float floatValue = this.value.floatValue();
        if (!Float.isFinite(floatValue)) {
            return false;
        }
        try {
            return new BigDecimal(floatValue).toBigIntegerExact().equals(this.value);
        }
        catch (ArithmeticException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean fitsInLong() {
        return this.value.bitLength() < 64;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean fitsInInt() {
        return this.value.bitLength() < 32;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean fitsInDouble() {
        if (this.value.bitLength() <= 53) {
            return true;
        }
        double doubleValue = this.value.doubleValue();
        if (!Double.isFinite(doubleValue)) {
            return false;
        }
        try {
            return new BigDecimal(doubleValue).toBigIntegerExact().equals(this.value);
        }
        catch (ArithmeticException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    @ExportMessage
    public boolean fitsInBigInteger() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    double asDouble() throws UnsupportedMessageException {
        if (this.fitsInDouble()) {
            return this.value.doubleValue();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    long asLong() throws UnsupportedMessageException {
        if (this.fitsInLong()) {
            return this.value.longValue();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    byte asByte() throws UnsupportedMessageException {
        if (this.fitsInByte()) {
            return this.value.byteValue();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    int asInt() throws UnsupportedMessageException {
        if (this.fitsInInt()) {
            return this.value.intValue();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    float asFloat() throws UnsupportedMessageException {
        if (this.fitsInFloat()) {
            return this.value.floatValue();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    short asShort() throws UnsupportedMessageException {
        if (this.fitsInShort()) {
            return this.value.shortValue();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    BigInteger asBigInteger() {
        return this.value;
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return SLLanguage.class;
    }

    @ExportMessage
    boolean hasMetaObject() {
        return true;
    }

    @ExportMessage
    Object getMetaObject() {
        return SLType.NUMBER;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object toDisplayString(boolean allowSideEffects) {
        return this.value.toString();
    }
}

