/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.bytecode.BytecodeConfig;
import com.oracle.truffle.api.bytecode.BytecodeLabel;
import com.oracle.truffle.api.bytecode.BytecodeLocal;
import com.oracle.truffle.api.bytecode.BytecodeParser;
import com.oracle.truffle.api.bytecode.BytecodeRootNodes;
import com.oracle.truffle.api.bytecode.BytecodeTier;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.bytecode.SLBytecodeRootNode;
import com.oracle.truffle.sl.bytecode.SLBytecodeRootNodeGen;
import com.oracle.truffle.sl.parser.SLBaseParser;
import com.oracle.truffle.sl.parser.SimpleLanguageParser;
import com.oracle.truffle.sl.runtime.SLBigInteger;
import com.oracle.truffle.sl.runtime.SLNull;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public final class SLBytecodeParser
extends SLBaseParser {
    private static final boolean DO_LOG_NODE_CREATION = false;
    private static final boolean FORCE_SERIALIZE = false;
    private static final boolean FORCE_MATERIALIZE_COMPLETE = false;
    private static final Class<?>[] EXPRESSION = new Class[]{StandardTags.ExpressionTag.class};
    private static final Class<?>[] READ_VARIABLE = new Class[]{StandardTags.ExpressionTag.class, StandardTags.ReadVariableTag.class};
    private static final Class<?>[] WRITE_VARIABLE = new Class[]{StandardTags.ExpressionTag.class, StandardTags.WriteVariableTag.class};
    private static final Class<?>[] STATEMENT = new Class[]{StandardTags.StatementTag.class};
    private static final Class<?>[] CONDITION = new Class[]{StandardTags.StatementTag.class, StandardTags.ExpressionTag.class};
    private static final Class<?>[] CALL = new Class[]{StandardTags.CallTag.class, StandardTags.ExpressionTag.class};
    private final SLBytecodeRootNodeGen.Builder b;
    private BytecodeLabel breakLabel;
    private BytecodeLabel continueLabel;
    private final ArrayList<Object> locals = new ArrayList();
    ArrayDeque<Class<?>[]> tagStack = new ArrayDeque();

    public static void parseSL(SLLanguage language, Source source, Map<TruffleString, RootCallTarget> functions) {
        BytecodeParser slParser = b -> {
            SLBytecodeParser visitor = new SLBytecodeParser(language, source, (SLBytecodeRootNodeGen.Builder)b);
            b.beginSource(source);
            SLBytecodeParser.parseSLImpl(source, visitor);
            b.endSource();
        };
        BytecodeRootNodes<SLBytecodeRootNode> nodes = SLBytecodeRootNodeGen.create(language, BytecodeConfig.DEFAULT, (BytecodeParser<SLBytecodeRootNodeGen.Builder>)slParser);
        block4: for (SLBytecodeRootNode node : nodes.getNodes()) {
            TruffleString name = node.getTSName();
            RootCallTarget callTarget = node.getCallTarget();
            functions.put(name, callTarget);
            BytecodeTier tier = language.getForceBytecodeTier();
            if (tier == null) continue;
            switch (tier) {
                case CACHED: {
                    node.getBytecodeNode().setUncachedThreshold(0);
                    continue block4;
                }
                case UNCACHED: {
                    node.getBytecodeNode().setUncachedThreshold(Integer.MIN_VALUE);
                    continue block4;
                }
            }
            throw CompilerDirectives.shouldNotReachHere((String)("Unexpected tier: " + String.valueOf(tier)));
        }
    }

    public static Map<TruffleString, RootCallTarget> parseSL(SLLanguage language, Source source) {
        HashMap<TruffleString, RootCallTarget> roots = new HashMap<TruffleString, RootCallTarget>();
        SLBytecodeParser.parseSL(language, source, roots);
        return roots;
    }

    private SLBytecodeParser(SLLanguage language, Source source, SLBytecodeRootNodeGen.Builder builder) {
        super(language, source);
        this.b = builder;
    }

    private void beginSourceSection(Token token) throws AssertionError {
        this.b.beginSourceSection(token.getStartIndex(), token.getText().length());
    }

    @Override
    public Void visitFunction(SimpleLanguageParser.FunctionContext ctx) {
        Token nameToken = ctx.IDENTIFIER(0).getSymbol();
        TruffleString name = this.asTruffleString(nameToken, false);
        int functionStartPos = nameToken.getStartIndex();
        int functionEndPos = ctx.getStop().getStopIndex();
        this.b.beginSourceSection(functionStartPos, functionEndPos - functionStartPos + 1);
        this.b.beginRoot();
        this.b.beginBlock();
        int parameterCount = this.enterFunction(ctx).size();
        for (int i = 0; i < parameterCount; ++i) {
            Token paramToken = ctx.IDENTIFIER(i + 1).getSymbol();
            TruffleString paramName = this.asTruffleString(paramToken, false);
            BytecodeLocal argLocal = this.b.createLocal(paramName, null);
            this.locals.add(argLocal);
            this.b.beginStoreLocal(argLocal);
            this.beginSourceSection(paramToken);
            this.b.emitSLLoadArgument(i);
            this.b.endSourceSection();
            this.b.endStoreLocal();
        }
        this.b.beginTag(StandardTags.RootBodyTag.class);
        this.b.beginBlock();
        this.visit((ParseTree)ctx.body);
        this.exitFunction();
        this.locals.clear();
        this.b.endBlock();
        this.b.endTag(StandardTags.RootBodyTag.class);
        this.b.endBlock();
        this.b.beginReturn();
        this.b.emitLoadConstant(SLNull.SINGLETON);
        this.b.endReturn();
        SLBytecodeRootNode node = this.b.endRoot();
        node.setParameterCount(parameterCount);
        node.setTSName(name);
        this.b.endSourceSection();
        return null;
    }

    @Override
    public Void visitBlock(SimpleLanguageParser.BlockContext ctx) {
        this.b.beginBlock();
        List<TruffleString> newLocals = this.enterBlock(ctx);
        for (TruffleString local : newLocals) {
            this.locals.add(local);
        }
        for (SimpleLanguageParser.StatementContext child : ctx.statement()) {
            this.visit((ParseTree)child);
        }
        this.exitBlock();
        this.b.toString();
        this.b.endBlock();
        return null;
    }

    @Override
    public Void visitStatement(SimpleLanguageParser.StatementContext ctx) {
        SimpleLanguageParser.StatementContext tree = ctx;
        if (tree.getChildCount() == 1) {
            tree = tree.getChild(0);
        }
        if (tree instanceof SimpleLanguageParser.Return_statementContext) {
            SimpleLanguageParser.Return_statementContext ret = (SimpleLanguageParser.Return_statementContext)((Object)tree);
            int start = ret.getStart().getStartIndex();
            int end = ret.expression() == null ? ctx.getStop().getStopIndex() : ret.expression().getStop().getStopIndex();
            this.beginAttribution(STATEMENT, start, end);
            super.visitStatement(ctx);
            this.endAttribution(STATEMENT);
        } else if (tree instanceof SimpleLanguageParser.If_statementContext || tree instanceof SimpleLanguageParser.While_statementContext) {
            super.visitStatement(ctx);
        } else {
            if (tree.getChildCount() == 2) {
                tree = tree.getChild(0);
            }
            this.beginAttribution(STATEMENT, (ParseTree)tree);
            super.visitStatement(ctx);
            this.endAttribution(STATEMENT);
        }
        return null;
    }

    @Override
    public Void visitBreak_statement(SimpleLanguageParser.Break_statementContext ctx) {
        if (this.breakLabel == null) {
            this.semErr(ctx.b, "break used outside of loop");
        }
        this.b.emitBranch(this.breakLabel);
        return null;
    }

    @Override
    public Void visitContinue_statement(SimpleLanguageParser.Continue_statementContext ctx) {
        if (this.continueLabel == null) {
            this.semErr(ctx.c, "continue used outside of loop");
        }
        this.b.emitBranch(this.continueLabel);
        return null;
    }

    @Override
    public Void visitDebugger_statement(SimpleLanguageParser.Debugger_statementContext ctx) {
        this.b.emitSLAlwaysHalt();
        return null;
    }

    @Override
    public Void visitWhile_statement(SimpleLanguageParser.While_statementContext ctx) {
        BytecodeLabel oldBreak = this.breakLabel;
        BytecodeLabel oldContinue = this.continueLabel;
        this.b.beginBlock();
        this.breakLabel = this.b.createLabel();
        this.continueLabel = this.b.createLabel();
        this.b.emitLabel(this.continueLabel);
        this.b.beginWhile();
        this.b.beginSLToBoolean();
        this.beginAttribution(CONDITION, (ParseTree)ctx.condition);
        this.visit((ParseTree)ctx.condition);
        this.endAttribution(CONDITION);
        this.b.endSLToBoolean();
        this.visit((ParseTree)ctx.body);
        this.b.endWhile();
        this.b.emitLabel(this.breakLabel);
        this.b.endBlock();
        this.breakLabel = oldBreak;
        this.continueLabel = oldContinue;
        return null;
    }

    @Override
    public Void visitIf_statement(SimpleLanguageParser.If_statementContext ctx) {
        if (ctx.alt == null) {
            this.b.beginIfThen();
            this.beginAttribution(CONDITION, (ParseTree)ctx.condition);
            this.b.beginSLToBoolean();
            this.visit((ParseTree)ctx.condition);
            this.b.endSLToBoolean();
            this.endAttribution(CONDITION);
            this.visit((ParseTree)ctx.then);
            this.b.endIfThen();
        } else {
            this.b.beginIfThenElse();
            this.beginAttribution(CONDITION, (ParseTree)ctx.condition);
            this.b.beginSLToBoolean();
            this.visit((ParseTree)ctx.condition);
            this.b.endSLToBoolean();
            this.endAttribution(CONDITION);
            this.visit((ParseTree)ctx.then);
            this.visit((ParseTree)ctx.alt);
            this.b.endIfThenElse();
        }
        return null;
    }

    @Override
    public Void visitReturn_statement(SimpleLanguageParser.Return_statementContext ctx) {
        this.b.beginReturn();
        if (ctx.expression() == null) {
            this.b.emitLoadConstant(SLNull.SINGLETON);
        } else {
            this.visit((ParseTree)ctx.expression());
        }
        this.b.endReturn();
        return null;
    }

    @Override
    public Void visitExpression(SimpleLanguageParser.ExpressionContext ctx) {
        List<SimpleLanguageParser.Logic_termContext> terms = ctx.logic_term();
        if (terms.size() == 1) {
            this.visit((ParseTree)terms.get(0));
        } else {
            this.b.beginSLOr();
            this.emitShortCircuitOperands(terms);
            this.b.endSLOr();
        }
        return null;
    }

    @Override
    public Void visitLogic_term(SimpleLanguageParser.Logic_termContext ctx) {
        List<SimpleLanguageParser.Logic_factorContext> factors = ctx.logic_factor();
        if (factors.size() == 1) {
            this.visit((ParseTree)factors.get(0));
        } else {
            this.beginAttribution(EXPRESSION, (ParseTree)ctx);
            this.b.beginSLAnd();
            this.emitShortCircuitOperands(factors);
            this.b.endSLAnd();
            this.endAttribution(EXPRESSION);
        }
        return null;
    }

    private void emitShortCircuitOperands(List<? extends ParseTree> operands) {
        for (int i = 0; i < operands.size(); ++i) {
            this.visit(operands.get(i));
        }
    }

    @Override
    public Void visitLogic_factor(SimpleLanguageParser.Logic_factorContext ctx) {
        if (ctx.arithmetic().size() == 1) {
            return (Void)this.visit((ParseTree)ctx.arithmetic(0));
        }
        this.beginAttribution(EXPRESSION, (ParseTree)ctx);
        switch (ctx.OP_COMPARE().getText()) {
            case "<": {
                this.b.beginSLLessThan();
                this.visitUnboxed((RuleContext)ctx.arithmetic(0));
                this.visitUnboxed((RuleContext)ctx.arithmetic(1));
                this.b.endSLLessThan();
                break;
            }
            case "<=": {
                this.b.beginSLLessOrEqual();
                this.visitUnboxed((RuleContext)ctx.arithmetic(0));
                this.visitUnboxed((RuleContext)ctx.arithmetic(1));
                this.b.endSLLessOrEqual();
                break;
            }
            case ">": {
                this.b.beginSLLogicalNot();
                this.b.beginSLLessOrEqual();
                this.visitUnboxed((RuleContext)ctx.arithmetic(0));
                this.visitUnboxed((RuleContext)ctx.arithmetic(1));
                this.b.endSLLessOrEqual();
                this.b.endSLLogicalNot();
                break;
            }
            case ">=": {
                this.b.beginSLLogicalNot();
                this.b.beginSLLessThan();
                this.visitUnboxed((RuleContext)ctx.arithmetic(0));
                this.visitUnboxed((RuleContext)ctx.arithmetic(1));
                this.b.endSLLessThan();
                this.b.endSLLogicalNot();
                break;
            }
            case "==": {
                this.b.beginSLEqual();
                this.visitUnboxed((RuleContext)ctx.arithmetic(0));
                this.visitUnboxed((RuleContext)ctx.arithmetic(1));
                this.b.endSLEqual();
                break;
            }
            case "!=": {
                this.b.beginSLLogicalNot();
                this.b.beginSLEqual();
                this.visitUnboxed((RuleContext)ctx.arithmetic(0));
                this.visitUnboxed((RuleContext)ctx.arithmetic(1));
                this.b.endSLEqual();
                this.b.endSLLogicalNot();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.endAttribution(EXPRESSION);
        return null;
    }

    private void visitUnboxed(RuleContext ctx) {
        if (this.needsUnboxing((ParseTree)ctx)) {
            this.b.beginSLUnbox();
            this.visit((ParseTree)ctx);
            this.b.endSLUnbox();
        } else {
            this.visit((ParseTree)ctx);
        }
    }

    private boolean needsUnboxing(ParseTree tree) {
        if (tree instanceof SimpleLanguageParser.NumericLiteralContext || tree instanceof SimpleLanguageParser.StringLiteralContext) {
            return false;
        }
        for (int i = 0; i < tree.getChildCount(); ++i) {
            if (!this.needsUnboxing(tree.getChild(i))) continue;
            return true;
        }
        return tree.getChildCount() == 0;
    }

    @Override
    public Void visitArithmetic(SimpleLanguageParser.ArithmeticContext ctx) {
        if (!ctx.OP_ADD().isEmpty()) {
            int i;
            this.beginAttribution(EXPRESSION, (ParseTree)ctx);
            block16: for (i = ctx.OP_ADD().size() - 1; i >= 0; --i) {
                switch (ctx.OP_ADD(i).getText()) {
                    case "+": {
                        this.b.beginSLAdd();
                        continue block16;
                    }
                    case "-": {
                        this.b.beginSLSub();
                        continue block16;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            this.visitUnboxed((RuleContext)ctx.term(0));
            block17: for (i = 0; i < ctx.OP_ADD().size(); ++i) {
                this.visitUnboxed((RuleContext)ctx.term(i + 1));
                switch (ctx.OP_ADD(i).getText()) {
                    case "+": {
                        this.b.endSLAdd();
                        continue block17;
                    }
                    case "-": {
                        this.b.endSLSub();
                        continue block17;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            this.endAttribution(EXPRESSION);
        } else {
            this.visit((ParseTree)ctx.term(0));
        }
        return null;
    }

    @Override
    public Void visitTerm(SimpleLanguageParser.TermContext ctx) {
        if (!ctx.OP_MUL().isEmpty()) {
            int i;
            this.beginAttribution(EXPRESSION, (ParseTree)ctx);
            block16: for (i = ctx.OP_MUL().size() - 1; i >= 0; --i) {
                switch (ctx.OP_MUL(i).getText()) {
                    case "*": {
                        this.b.beginSLMul();
                        continue block16;
                    }
                    case "/": {
                        this.b.beginSLDiv();
                        continue block16;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            this.visitUnboxed((RuleContext)ctx.factor(0));
            block17: for (i = 0; i < ctx.OP_MUL().size(); ++i) {
                this.visitUnboxed((RuleContext)ctx.factor(i + 1));
                switch (ctx.OP_MUL(i).getText()) {
                    case "*": {
                        this.b.endSLMul();
                        continue block17;
                    }
                    case "/": {
                        this.b.endSLDiv();
                        continue block17;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            this.endAttribution(EXPRESSION);
        } else {
            this.visit((ParseTree)ctx.factor(0));
        }
        return null;
    }

    @Override
    public Void visitNameAccess(SimpleLanguageParser.NameAccessContext ctx) {
        this.buildMemberExpressionRead(ctx.IDENTIFIER().getSymbol(), ctx.member_expression(), ctx.member_expression().size() - 1);
        return null;
    }

    private void buildMemberExpressionRead(Token ident, List<SimpleLanguageParser.Member_expressionContext> members, int idx) {
        if (idx == -1) {
            int localIdx = this.getLocalIndex(ident);
            if (localIdx != -1) {
                this.beginAttribution(READ_VARIABLE, ident);
                this.b.emitLoadLocal(this.accessLocal(localIdx));
                this.endAttribution(READ_VARIABLE);
            } else {
                this.beginAttribution(EXPRESSION, ident);
                this.b.beginSLFunctionLiteral();
                this.b.emitLoadConstant(this.asTruffleString(ident, false));
                this.b.endSLFunctionLiteral();
                this.endAttribution(EXPRESSION);
            }
            return;
        }
        SimpleLanguageParser.Member_expressionContext last = members.get(idx);
        if (last instanceof SimpleLanguageParser.MemberCallContext) {
            SimpleLanguageParser.MemberCallContext lastCtx = (SimpleLanguageParser.MemberCallContext)last;
            this.beginAttribution(CALL, ident.getStartIndex(), lastCtx.getStop().getStopIndex());
            this.b.beginSLInvoke();
            this.buildMemberExpressionRead(ident, members, idx - 1);
            for (SimpleLanguageParser.ExpressionContext arg : lastCtx.expression()) {
                this.visit((ParseTree)arg);
            }
            this.b.endSLInvoke();
            this.endAttribution(CALL);
        } else if (last instanceof SimpleLanguageParser.MemberAssignContext) {
            SimpleLanguageParser.MemberAssignContext lastCtx = (SimpleLanguageParser.MemberAssignContext)last;
            int index = idx - 1;
            if (index == -1) {
                int localIdx = this.getLocalIndex(ident);
                assert (localIdx != -1);
                this.beginAttribution(WRITE_VARIABLE, ident.getStartIndex(), lastCtx.getStop().getStopIndex());
                BytecodeLocal local = this.accessLocal(localIdx);
                this.b.beginBlock();
                this.b.beginStoreLocal(local);
                this.visit((ParseTree)lastCtx.expression());
                this.b.endStoreLocal();
                this.b.emitLoadLocal(local);
                this.b.endBlock();
                this.endAttribution(WRITE_VARIABLE);
            } else {
                SimpleLanguageParser.Member_expressionContext last1 = members.get(index);
                if (last1 instanceof SimpleLanguageParser.MemberCallContext) {
                    this.semErr(lastCtx.expression().start, "invalid assignment target");
                } else if (last1 instanceof SimpleLanguageParser.MemberAssignContext) {
                    this.semErr(lastCtx.expression().start, "invalid assignment target");
                } else if (last1 instanceof SimpleLanguageParser.MemberFieldContext) {
                    SimpleLanguageParser.MemberFieldContext lastCtx1 = (SimpleLanguageParser.MemberFieldContext)last1;
                    this.b.beginSLWriteProperty();
                    this.buildMemberExpressionRead(ident, members, index - 1);
                    this.b.emitLoadConstant(this.asTruffleString(lastCtx1.IDENTIFIER().getSymbol(), false));
                    this.visit((ParseTree)lastCtx.expression());
                    this.b.endSLWriteProperty();
                } else {
                    SimpleLanguageParser.MemberIndexContext lastCtx2 = (SimpleLanguageParser.MemberIndexContext)last1;
                    this.b.beginSLWriteProperty();
                    this.buildMemberExpressionRead(ident, members, index - 1);
                    this.visit((ParseTree)lastCtx2.expression());
                    this.visit((ParseTree)lastCtx.expression());
                    this.b.endSLWriteProperty();
                }
            }
        } else if (last instanceof SimpleLanguageParser.MemberFieldContext) {
            SimpleLanguageParser.MemberFieldContext lastCtx = (SimpleLanguageParser.MemberFieldContext)last;
            this.b.beginSLReadProperty();
            this.buildMemberExpressionRead(ident, members, idx - 1);
            this.b.emitLoadConstant(this.asTruffleString(lastCtx.IDENTIFIER().getSymbol(), false));
            this.b.endSLReadProperty();
        } else {
            SimpleLanguageParser.MemberIndexContext lastCtx = (SimpleLanguageParser.MemberIndexContext)last;
            this.b.beginSLReadProperty();
            this.buildMemberExpressionRead(ident, members, idx - 1);
            this.visit((ParseTree)lastCtx.expression());
            this.b.endSLReadProperty();
        }
    }

    private BytecodeLocal accessLocal(int localIdx) {
        Object local = this.locals.get(localIdx);
        if (local instanceof TruffleString) {
            TruffleString s = (TruffleString)local;
            local = this.b.createLocal(s, null);
            this.locals.set(localIdx, local);
        }
        return (BytecodeLocal)local;
    }

    @Override
    public Void visitStringLiteral(SimpleLanguageParser.StringLiteralContext ctx) {
        this.beginAttribution(EXPRESSION, (ParseTree)ctx);
        this.b.emitLoadConstant(this.asTruffleString(ctx.STRING_LITERAL().getSymbol(), true));
        this.endAttribution(EXPRESSION);
        return null;
    }

    @Override
    public Void visitNumericLiteral(SimpleLanguageParser.NumericLiteralContext ctx) {
        Comparable<Long> value;
        this.beginAttribution(EXPRESSION, (ParseTree)ctx);
        try {
            value = Long.parseLong(ctx.NUMERIC_LITERAL().getText());
        }
        catch (NumberFormatException ex) {
            value = new SLBigInteger(new BigInteger(ctx.NUMERIC_LITERAL().getText()));
        }
        this.b.emitLoadConstant(value);
        this.endAttribution(EXPRESSION);
        return null;
    }

    private void beginAttribution(Class<?>[] tags, ParseTree tree) {
        this.beginAttribution(tags, SLBytecodeParser.getStartIndex(tree), SLBytecodeParser.getEndIndex(tree));
    }

    private static int getEndIndex(ParseTree tree) {
        if (tree instanceof ParserRuleContext) {
            ParserRuleContext ctx = (ParserRuleContext)tree;
            return ctx.getStop().getStopIndex();
        }
        if (tree instanceof TerminalNode) {
            TerminalNode node = (TerminalNode)tree;
            return node.getSymbol().getStopIndex();
        }
        throw new AssertionError((Object)("unknown tree type: " + String.valueOf(tree)));
    }

    private static int getStartIndex(ParseTree tree) {
        if (tree instanceof ParserRuleContext) {
            ParserRuleContext ctx = (ParserRuleContext)tree;
            return ctx.getStart().getStartIndex();
        }
        if (tree instanceof TerminalNode) {
            TerminalNode node = (TerminalNode)tree;
            return node.getSymbol().getStartIndex();
        }
        throw new AssertionError((Object)("unknown tree type: " + String.valueOf(tree)));
    }

    private void beginAttribution(Class<?>[] tags, Token token) {
        this.beginAttribution(tags, token.getStartIndex(), token.getStopIndex());
    }

    private void beginAttribution(Class<?>[] tags, int start, int end) {
        boolean parentCondition = this.tagStack.peek() == CONDITION;
        this.tagStack.push(tags);
        if (parentCondition) {
            return;
        }
        this.beginSourceSection(start, end);
        this.b.beginTag(tags);
    }

    private void beginSourceSection(int start, int end) {
        int length = end - start + 1;
        assert (length >= 0);
        this.b.beginSourceSection(start, length);
    }

    private void endAttribution(Class<?>[] tags) {
        boolean parentCondition;
        this.tagStack.pop();
        boolean bl = parentCondition = this.tagStack.peek() == CONDITION;
        if (parentCondition) {
            return;
        }
        this.b.endTag(tags);
        this.b.endSourceSection();
    }
}

