/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.parser;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.parser.SLParseError;
import com.oracle.truffle.sl.parser.SimpleLanguageBaseVisitor;
import com.oracle.truffle.sl.parser.SimpleLanguageLexer;
import com.oracle.truffle.sl.parser.SimpleLanguageParser;
import com.oracle.truffle.sl.runtime.SLStrings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public abstract class SLBaseParser
extends SimpleLanguageBaseVisitor<Void> {
    protected final SLLanguage language;
    protected final Source source;
    protected final TruffleString sourceString;
    private int totalLocals = 0;
    private LocalScope curScope = null;

    protected static void parseSLImpl(Source source, SLBaseParser visitor) {
        SimpleLanguageLexer lexer = new SimpleLanguageLexer((CharStream)CharStreams.fromString((String)source.getCharacters().toString()));
        SimpleLanguageParser parser = new SimpleLanguageParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        BailoutErrorListener listener = new BailoutErrorListener(source);
        lexer.addErrorListener((ANTLRErrorListener)listener);
        parser.addErrorListener((ANTLRErrorListener)listener);
        parser.simplelanguage().accept(visitor);
    }

    protected SLBaseParser(SLLanguage language, Source source) {
        this.language = language;
        this.source = source;
        this.sourceString = SLStrings.fromJavaString(source.getCharacters().toString());
    }

    protected void semErr(Token token, String message) {
        assert (token != null);
        SLBaseParser.throwParseError(this.source, token.getLine(), token.getCharPositionInLine(), token, message);
    }

    private static void throwParseError(Source source, int line, int charPositionInLine, Token token, String message) {
        int col = charPositionInLine + 1;
        String location = "-- line " + line + " col " + col + ": ";
        int length = token == null ? 1 : Math.max(token.getStopIndex() - token.getStartIndex(), 0);
        throw new SLParseError(source, line, col, length, String.format("Error(s) parsing script:%n" + location + message, new Object[0]));
    }

    protected TruffleString asTruffleString(Token literalToken, boolean removeQuotes) {
        int fromIndex = literalToken.getStartIndex();
        int length = literalToken.getStopIndex() - literalToken.getStartIndex() + 1;
        if (removeQuotes) {
            assert (literalToken.getText().length() >= 2 && literalToken.getText().startsWith("\"") && literalToken.getText().endsWith("\""));
            ++fromIndex;
            length -= 2;
        }
        return this.sourceString.substringByteIndexUncached(fromIndex * 2, length * 2, SLLanguage.STRING_ENCODING, true);
    }

    protected final List<TruffleString> enterFunction(SimpleLanguageParser.FunctionContext ctx) {
        ArrayList<TruffleString> result = new ArrayList<TruffleString>();
        assert (this.curScope == null);
        this.curScope = new LocalScope();
        this.totalLocals = 0;
        for (int i = 1; i < ctx.IDENTIFIER().size(); ++i) {
            TruffleString paramName = this.asTruffleString(ctx.IDENTIFIER(i).getSymbol(), false);
            this.curScope.declareLocal(paramName);
            result.add(paramName);
        }
        return result;
    }

    protected final void exitFunction() {
        this.curScope = this.curScope.parent;
        assert (this.curScope == null);
    }

    protected final List<TruffleString> enterBlock(SimpleLanguageParser.BlockContext ctx) {
        ArrayList<TruffleString> result = new ArrayList<TruffleString>();
        this.curScope = new LocalScope(this.curScope);
        FindLocalsVisitor findLocals = new FindLocalsVisitor();
        findLocals.visitBlock(ctx);
        for (Token tok : findLocals.results) {
            TruffleString name = this.asTruffleString(tok, false);
            if (this.curScope.localDeclared(name)) continue;
            this.curScope.declareLocal(name);
            result.add(name);
        }
        return result;
    }

    protected final void exitBlock() {
        this.curScope = this.curScope.parent;
    }

    protected final int getLocalIndex(TruffleString name) {
        return this.curScope.getLocalIndex(name);
    }

    protected final int getLocalIndex(Token name) {
        return this.curScope.getLocalIndex(this.asTruffleString(name, false));
    }

    protected final boolean initializeLocal(TruffleString name) {
        return this.curScope.initializeLocal(name);
    }

    private static final class BailoutErrorListener
    extends BaseErrorListener {
        private final Source source;

        BailoutErrorListener(Source source) {
            this.source = source;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            SLBaseParser.throwParseError(this.source, line, charPositionInLine, (Token)offendingSymbol, msg);
        }
    }

    private class LocalScope {
        final LocalScope parent;
        private final Map<TruffleString, Integer> locals;
        private final Set<TruffleString> initialized;

        LocalScope(LocalScope parent) {
            this.parent = parent;
            this.locals = new HashMap<TruffleString, Integer>(parent.locals);
            this.initialized = new HashSet<TruffleString>(parent.initialized);
        }

        LocalScope() {
            this.parent = null;
            this.locals = new HashMap<TruffleString, Integer>();
            this.initialized = new HashSet<TruffleString>();
        }

        boolean localDeclared(TruffleString name) {
            return this.locals.containsKey(name);
        }

        void declareLocal(TruffleString name) {
            this.locals.put(name, SLBaseParser.this.totalLocals++);
        }

        Integer getLocalIndex(TruffleString name) {
            Integer i = this.locals.get(name);
            if (i == null) {
                return -1;
            }
            return i;
        }

        boolean initializeLocal(TruffleString name) {
            return this.initialized.add(name);
        }
    }

    private static class FindLocalsVisitor
    extends SimpleLanguageBaseVisitor<Void> {
        boolean entered = false;
        List<Token> results = new ArrayList<Token>();

        private FindLocalsVisitor() {
        }

        @Override
        public Void visitBlock(SimpleLanguageParser.BlockContext ctx) {
            if (this.entered) {
                return null;
            }
            this.entered = true;
            return (Void)super.visitBlock(ctx);
        }

        @Override
        public Void visitNameAccess(SimpleLanguageParser.NameAccessContext ctx) {
            if (ctx.member_expression().size() > 0 && ctx.member_expression(0) instanceof SimpleLanguageParser.MemberAssignContext) {
                this.results.add(ctx.IDENTIFIER().getSymbol());
            }
            return (Void)super.visitNameAccess(ctx);
        }
    }
}

