/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.util;

import com.oracle.truffle.api.bytecode.OperationProxy;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.sl.SLException;
import com.oracle.truffle.sl.nodes.SLExpressionNode;

@NodeInfo(shortName="toBoolean")
@NodeChild
@OperationProxy.Proxyable(allowUncached=true)
public abstract class SLToBooleanNode
extends SLExpressionNode {
    @Override
    public abstract boolean executeBoolean(VirtualFrame var1);

    @Specialization
    public static boolean doBoolean(boolean value) {
        return value;
    }

    @Specialization(guards={"lib.isBoolean(value)"}, limit="3")
    public static boolean doInterop(Object value, @Bind Node node, @CachedLibrary(value="value") InteropLibrary lib) {
        try {
            return lib.asBoolean(value);
        }
        catch (UnsupportedMessageException e) {
            return SLToBooleanNode.doFallback(value, node);
        }
    }

    @Fallback
    public static boolean doFallback(Object value, @Bind Node node) {
        throw SLException.typeError(node, "toBoolean", value);
    }
}

