/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.local;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.sl.nodes.local.SLScopedNode;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(value=SLScopedNode.class)
public final class SLScopedNodeGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private SLScopedNodeGen() {
    }

    static {
        LibraryExport.register(SLScopedNode.class, (LibraryExport[])new LibraryExport[]{new NodeLibraryExports()});
    }

    @GeneratedBy(value=SLScopedNode.class)
    public static class NodeLibraryExports
    extends LibraryExport<NodeLibrary> {
        private NodeLibraryExports() {
            super(NodeLibrary.class, SLScopedNode.class, false, false, 0);
        }

        protected NodeLibrary createUncached(Object receiver) {
            assert (receiver instanceof SLScopedNode);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected NodeLibrary createCached(Object receiver) {
            assert (receiver instanceof SLScopedNode);
            return new Cached(receiver);
        }

        @GeneratedBy(value=SLScopedNode.class)
        public static class Uncached
        extends NodeLibrary
        implements UnadoptableNode {
            private final Class<? extends SLScopedNode> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((Object)((Object)((SLScopedNode)((Object)receiver)))).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_) && Uncached.accepts_(receiver);
            }

            public boolean hasScope(Object receiver, Frame frame) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((SLScopedNode)((Object)receiver)).hasScope(frame);
            }

            public Object getScope(Object arg0Value_, Frame arg1Value, boolean arg2Value) throws UnsupportedMessageException {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                SLScopedNode arg0Value = (SLScopedNode)((Object)arg0Value_);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return arg0Value.getScope(arg1Value, arg2Value, arg0Value, arg0Value.findBlock());
            }

            public boolean hasRootInstance(Object receiver, Frame frame) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((SLScopedNode)((Object)receiver)).hasRootInstance(frame);
            }

            public Object getRootInstance(Object receiver, Frame frame) throws UnsupportedMessageException {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((SLScopedNode)((Object)receiver)).getRootInstance(frame);
            }

            @CompilerDirectives.TruffleBoundary
            private static boolean accepts_(Object arg0Value_) {
                SLScopedNode arg0Value = (SLScopedNode)((Object)arg0Value_);
                return arg0Value.accepts(arg0Value);
            }
        }

        @GeneratedBy(value=SLScopedNode.class)
        public static class Cached
        extends NodeLibrary {
            private final Class<? extends SLScopedNode> receiverClass_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @CompilerDirectives.CompilationFinal
            private SLScopedNode node;
            @CompilerDirectives.CompilationFinal
            private Node getScopeNode__getScope_blockNode_;

            protected Cached(Object receiver) {
                SLScopedNode castReceiver;
                SLScopedNode node_ = castReceiver = (SLScopedNode)((Object)receiver);
                VarHandle.storeStoreFence();
                this.node = node_;
                this.receiverClass_ = ((Object)((Object)castReceiver)).getClass();
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_) && this.accepts_(receiver);
            }

            private boolean accepts_(Object arg0Value_) {
                SLScopedNode arg0Value = (SLScopedNode)((Object)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_));
                return arg0Value.accepts(this.node);
            }

            public boolean hasScope(Object receiver, Frame frame) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (NodeLibraryExports.assertAdopted((Node)((Node)this)));
                return ((SLScopedNode)((Object)CompilerDirectives.castExact((Object)receiver, this.receiverClass_))).hasScope(frame);
            }

            public Object getScope(Object arg0Value_, Frame arg1Value, boolean arg2Value) throws UnsupportedMessageException {
                Node blockNode__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (NodeLibraryExports.assertAdopted((Node)((Node)this)));
                SLScopedNode arg0Value = (SLScopedNode)((Object)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_));
                int state_0 = this.state_0_;
                if (state_0 != 0 && (blockNode__ = this.getScopeNode__getScope_blockNode_) != null) {
                    return arg0Value.getScope(arg1Value, arg2Value, this.node, blockNode__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getScopeNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object getScopeNode_AndSpecialize(SLScopedNode arg0Value, Frame arg1Value, boolean arg2Value) {
                int state_0 = this.state_0_;
                Node blockNode__ = arg0Value.findBlock();
                Objects.requireNonNull(blockNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.getScopeNode__getScope_blockNode_ = blockNode__;
                this.state_0_ = state_0 |= 1;
                return arg0Value.getScope(arg1Value, arg2Value, this.node, blockNode__);
            }

            public boolean hasRootInstance(Object receiver, Frame frame) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (NodeLibraryExports.assertAdopted((Node)((Node)this)));
                return ((SLScopedNode)((Object)CompilerDirectives.castExact((Object)receiver, this.receiverClass_))).hasRootInstance(frame);
            }

            public Object getRootInstance(Object receiver, Frame frame) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (NodeLibraryExports.assertAdopted((Node)((Node)this)));
                return ((SLScopedNode)((Object)CompilerDirectives.castExact((Object)receiver, this.receiverClass_))).getRootInstance(frame);
            }
        }
    }
}

