/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.local;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import com.oracle.truffle.sl.nodes.interop.NodeObjectDescriptor;

@NodeField(name="slot", type=int.class)
public abstract class SLReadLocalVariableNode
extends SLExpressionNode {
    protected abstract int getSlot();

    @Specialization(guards={"frame.isLong(getSlot())"})
    protected long readLong(VirtualFrame frame) {
        return frame.getLong(this.getSlot());
    }

    @Specialization(guards={"frame.isBoolean(getSlot())"})
    protected boolean readBoolean(VirtualFrame frame) {
        return frame.getBoolean(this.getSlot());
    }

    @Specialization(replaces={"readLong", "readBoolean"})
    protected Object readObject(VirtualFrame frame) {
        if (!frame.isObject(this.getSlot())) {
            CompilerDirectives.transferToInterpreter();
            Object result = frame.getValue(this.getSlot());
            frame.setObject(this.getSlot(), result);
            return result;
        }
        return frame.getObject(this.getSlot());
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        return tag == StandardTags.ReadVariableTag.class || super.hasTag(tag);
    }

    public Object getNodeObject() {
        return NodeObjectDescriptor.readVariable((TruffleString)this.getRootNode().getFrameDescriptor().getSlotName(this.getSlot()));
    }
}

