/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.expression;

import com.oracle.truffle.api.bytecode.OperationProxy;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.SLException;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import com.oracle.truffle.sl.nodes.util.SLToMemberNode;
import com.oracle.truffle.sl.nodes.util.SLToTruffleStringNode;
import com.oracle.truffle.sl.runtime.SLObject;

@NodeInfo(shortName=".")
@NodeChildren(value={@NodeChild(value="receiverNode"), @NodeChild(value="nameNode")})
@OperationProxy.Proxyable(allowUncached=true)
public abstract class SLReadPropertyNode
extends SLExpressionNode {
    public static final int LIBRARY_LIMIT = 3;

    @Specialization(guards={"arrays.hasArrayElements(receiver)"}, limit="LIBRARY_LIMIT")
    public static Object readArray(Object receiver, Object index, @Bind Node node, @CachedLibrary(value="receiver") InteropLibrary arrays, @CachedLibrary(value="index") InteropLibrary numbers) {
        try {
            return arrays.readArrayElement(receiver, numbers.asLong(index));
        }
        catch (InvalidArrayIndexException | UnsupportedMessageException e) {
            throw SLException.undefinedProperty(node, index);
        }
    }

    @Specialization(limit="LIBRARY_LIMIT")
    public static Object readSLObject(SLObject receiver, Object name, @Bind Node node, @CachedLibrary(value="receiver") DynamicObjectLibrary objectLibrary, @Cached SLToTruffleStringNode toTruffleStringNode) {
        TruffleString nameTS = toTruffleStringNode.execute(node, name);
        Object result = objectLibrary.getOrDefault((DynamicObject)receiver, (Object)nameTS, null);
        if (result == null) {
            throw SLException.undefinedProperty(node, nameTS);
        }
        return result;
    }

    @Specialization(guards={"!isSLObject(receiver)", "objects.hasMembers(receiver)"}, limit="LIBRARY_LIMIT")
    public static Object readObject(Object receiver, Object name, @Bind Node node, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached SLToMemberNode asMember) {
        try {
            return objects.readMember(receiver, asMember.execute(node, name));
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e) {
            throw SLException.undefinedProperty(node, name);
        }
    }

    public static boolean isSLObject(Object receiver) {
        return receiver instanceof SLObject;
    }
}

