/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes.expression;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.bytecode.OperationProxy;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.nodes.SLBinaryNode;
import com.oracle.truffle.sl.runtime.SLBigInteger;
import com.oracle.truffle.sl.runtime.SLFunction;
import com.oracle.truffle.sl.runtime.SLNull;

@NodeInfo(shortName="==")
@OperationProxy.Proxyable(allowUncached=true)
public abstract class SLEqualNode
extends SLBinaryNode {
    @Specialization
    public static boolean doLong(long left, long right) {
        return left == right;
    }

    @Specialization
    @CompilerDirectives.TruffleBoundary
    public static boolean doBigNumber(SLBigInteger left, SLBigInteger right) {
        return left.equals(right);
    }

    @Specialization
    public static boolean doBoolean(boolean left, boolean right) {
        return left == right;
    }

    @Specialization
    public static boolean doString(String left, String right) {
        return left.equals(right);
    }

    @Specialization
    public static boolean doTruffleString(TruffleString left, TruffleString right, @Cached TruffleString.EqualNode equalNode) {
        return equalNode.execute((AbstractTruffleString)left, (AbstractTruffleString)right, SLLanguage.STRING_ENCODING);
    }

    @Specialization
    public static boolean doNull(SLNull left, SLNull right) {
        return left == right;
    }

    @Specialization
    public static boolean doFunction(SLFunction left, Object right) {
        return left == right;
    }

    @Specialization(limit="4")
    public static boolean doGeneric(Object left, Object right, @CachedLibrary(value="left") InteropLibrary leftInterop, @CachedLibrary(value="right") InteropLibrary rightInterop) {
        try {
            if (leftInterop.isBoolean(left) && rightInterop.isBoolean(right)) {
                return SLEqualNode.doBoolean(leftInterop.asBoolean(left), rightInterop.asBoolean(right));
            }
            if (leftInterop.isString(left) && rightInterop.isString(right)) {
                return SLEqualNode.doString(leftInterop.asString(left), rightInterop.asString(right));
            }
            if (leftInterop.isNull(left) && rightInterop.isNull(right)) {
                return true;
            }
            if (leftInterop.fitsInLong(left) && rightInterop.fitsInLong(right)) {
                return SLEqualNode.doLong(leftInterop.asLong(left), rightInterop.asLong(right));
            }
            if (left instanceof SLBigInteger && right instanceof SLBigInteger) {
                return SLEqualNode.doBigNumber((SLBigInteger)left, (SLBigInteger)right);
            }
            if (leftInterop.hasIdentity(left) && rightInterop.hasIdentity(right)) {
                return leftInterop.isIdentical(left, right, rightInterop);
            }
            return false;
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }
}

