/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.sl.nodes.SLTypes;
import com.oracle.truffle.sl.runtime.SLBigInteger;

@GeneratedBy(value=SLTypes.class)
public final class SLTypesGen
extends SLTypes {
    protected SLTypesGen() {
    }

    public static boolean isLong(Object value) {
        return value instanceof Long;
    }

    public static long asLong(Object value) {
        assert (value instanceof Long) : "SLTypesGen.asLong: long expected";
        return (Long)value;
    }

    public static long expectLong(Object value) throws UnexpectedResultException {
        if (value instanceof Long) {
            return (Long)value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isBoolean(Object value) {
        return value instanceof Boolean;
    }

    public static boolean asBoolean(Object value) {
        assert (value instanceof Boolean) : "SLTypesGen.asBoolean: boolean expected";
        return (Boolean)value;
    }

    public static boolean expectBoolean(Object value) throws UnexpectedResultException {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static SLBigInteger expectImplicitSLBigInteger(int state, Object value) throws UnexpectedResultException {
        if ((state & 1) != 0 && value instanceof SLBigInteger) {
            return (SLBigInteger)value;
        }
        if ((state & 2) != 0 && value instanceof Long) {
            return SLTypesGen.castBigNumber((Long)value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isImplicitSLBigInteger(int state, Object value) {
        return (state & 1) != 0 && value instanceof SLBigInteger || (state & 2) != 0 && value instanceof Long;
    }

    public static boolean isImplicitSLBigInteger(Object value) {
        return value instanceof SLBigInteger || value instanceof Long;
    }

    public static SLBigInteger asImplicitSLBigInteger(int state, Object value) {
        if (HostCompilerDirectives.inInterpreterFastPath()) {
            return SLTypesGen.asImplicitSLBigInteger(value);
        }
        if ((state & 1) != 0 && value instanceof SLBigInteger) {
            return (SLBigInteger)value;
        }
        if ((state & 2) != 0 && value instanceof Long) {
            return SLTypesGen.castBigNumber((Long)value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalArgumentException("Illegal implicit source type.");
    }

    public static SLBigInteger asImplicitSLBigInteger(Object value) {
        if (value instanceof SLBigInteger) {
            return (SLBigInteger)value;
        }
        if (value instanceof Long) {
            return SLTypesGen.castBigNumber((Long)value);
        }
        throw new IllegalArgumentException("Illegal implicit source type.");
    }

    public static int specializeImplicitSLBigInteger(Object value) {
        if (value instanceof SLBigInteger) {
            return 1;
        }
        if (value instanceof Long) {
            return 2;
        }
        return 0;
    }
}

