/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.sl.SLException;
import com.oracle.truffle.sl.builtins.SLBuiltinNode;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import com.oracle.truffle.sl.runtime.SLNull;

public abstract class SLBuiltinAstNode
extends SLExpressionNode {
    final int argumentCount;
    @Node.Child
    private SLBuiltinNode builtin;

    SLBuiltinAstNode(int argumentCount, SLBuiltinNode builtinNode) {
        this.argumentCount = argumentCount;
        this.builtin = builtinNode;
    }

    @Override
    public final Object executeGeneric(VirtualFrame frame) {
        try {
            return this.executeImpl(frame);
        }
        catch (UnsupportedSpecializationException e) {
            throw SLException.typeError(e.getNode(), e.getSuppliedValues());
        }
    }

    public abstract Object executeImpl(VirtualFrame var1);

    @Specialization(guards={"arguments.length == argumentCount"})
    final Object doInBounds(VirtualFrame frame, @Bind(value="frame.getArguments()") Object[] arguments) {
        return this.builtin.execute(frame, arguments);
    }

    @ExplodeLoop
    @Fallback
    final Object doOutOfBounds(VirtualFrame frame) {
        Object[] originalArguments = frame.getArguments();
        Object[] arguments = new Object[this.argumentCount];
        for (int i = 0; i < this.argumentCount; ++i) {
            arguments[i] = i < originalArguments.length ? originalArguments[i] : SLNull.SINGLETON;
        }
        return this.builtin.execute(frame, arguments);
    }
}

