/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import com.oracle.truffle.sl.nodes.SLRootNode;
import com.oracle.truffle.sl.nodes.SLStatementNode;
import com.oracle.truffle.sl.nodes.controlflow.SLBlockNode;
import com.oracle.truffle.sl.nodes.controlflow.SLFunctionBodyNode;
import com.oracle.truffle.sl.nodes.local.SLReadArgumentNode;
import com.oracle.truffle.sl.nodes.local.SLWriteLocalVariableNode;
import java.util.ArrayList;

public final class SLAstRootNode
extends SLRootNode {
    @Node.Child
    private SLExpressionNode bodyNode;
    private final SourceSection sourceSection;
    private final TruffleString name;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private SLWriteLocalVariableNode[] argumentNodesCache;

    public SLAstRootNode(SLLanguage language, FrameDescriptor frameDescriptor, SLExpressionNode bodyNode, SourceSection sourceSection, TruffleString name) {
        super(language, frameDescriptor);
        this.bodyNode = bodyNode;
        this.sourceSection = sourceSection;
        this.name = name;
    }

    @Override
    public SourceSection getSourceSection() {
        return this.sourceSection;
    }

    @Override
    public SLExpressionNode getBodyNode() {
        return this.bodyNode;
    }

    @Override
    public TruffleString getTSName() {
        return this.name;
    }

    public Object execute(VirtualFrame frame) {
        return this.bodyNode.executeGeneric(frame);
    }

    @Override
    public void setLocalValues(FrameInstance frameInstance, Object[] args) {
        Frame frame = frameInstance.getFrame(FrameInstance.FrameAccess.READ_WRITE);
        FrameDescriptor fd = this.getFrameDescriptor();
        int values = fd.getNumberOfSlots();
        for (int i = 0; i < values; ++i) {
            frame.setObject(i, args[i]);
        }
    }

    @Override
    public Object[] getLocalNames(FrameInstance frameInstance) {
        FrameDescriptor fd = this.getFrameDescriptor();
        int values = fd.getNumberOfSlots();
        Object[] localNames = new Object[values];
        for (int i = 0; i < values; ++i) {
            localNames[i] = fd.getSlotName(i);
        }
        return localNames;
    }

    @Override
    public Object[] getLocalValues(FrameInstance frameInstance) {
        Frame frame = frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY);
        FrameDescriptor fd = this.getFrameDescriptor();
        int values = fd.getNumberOfSlots();
        Object[] localNames = new Object[values];
        for (int i = 0; i < values; ++i) {
            localNames[i] = frame.getValue(i);
        }
        return localNames;
    }

    public SLWriteLocalVariableNode[] getDeclaredArguments() {
        SLWriteLocalVariableNode[] argumentNodes = this.argumentNodesCache;
        if (argumentNodes == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            argumentNodes = this.findArgumentNodes();
            this.argumentNodesCache = argumentNodes;
        }
        return argumentNodes;
    }

    @Override
    public SourceSection ensureSourceSection() {
        return this.getSourceSection();
    }

    private SLWriteLocalVariableNode[] findArgumentNodes() {
        final ArrayList writeArgNodes = new ArrayList(4);
        NodeUtil.forEachChild((Node)this.getBodyNode(), (NodeVisitor)new NodeVisitor(){
            private SLWriteLocalVariableNode wn;
            final /* synthetic */ SLAstRootNode this$0;
            {
                this.this$0 = this$0;
            }

            public boolean visit(Node node) {
                if (node instanceof InstrumentableNode.WrapperNode) {
                    return NodeUtil.forEachChild((Node)node, (NodeVisitor)this);
                }
                if (node instanceof SLWriteLocalVariableNode) {
                    this.wn = (SLWriteLocalVariableNode)node;
                    boolean all = NodeUtil.forEachChild((Node)node, (NodeVisitor)this);
                    this.wn = null;
                    return all;
                }
                if (this.wn != null && node instanceof SLReadArgumentNode) {
                    writeArgNodes.add(this.wn);
                    return true;
                }
                if (this.wn == null && node instanceof SLStatementNode && !(node instanceof SLBlockNode) && !(node instanceof SLFunctionBodyNode)) {
                    return false;
                }
                return NodeUtil.forEachChild((Node)node, (NodeVisitor)this);
            }
        });
        return writeArgNodes.toArray(new SLWriteLocalVariableNode[writeArgNodes.size()]);
    }
}

