/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.bytecode;

import com.oracle.truffle.api.bytecode.BytecodeConfig;
import com.oracle.truffle.api.bytecode.BytecodeParser;
import com.oracle.truffle.api.bytecode.BytecodeRootNodes;
import com.oracle.truffle.api.bytecode.serialization.SerializationUtils;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.bytecode.SLBytecodeRootNode;
import com.oracle.truffle.sl.bytecode.SLBytecodeRootNodeGen;
import com.oracle.truffle.sl.runtime.SLBigInteger;
import com.oracle.truffle.sl.runtime.SLNull;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.function.Supplier;

public final class SLBytecodeSerialization {
    private static final byte CODE_SL_NULL = 0;
    private static final byte CODE_STRING = 1;
    private static final byte CODE_LONG = 2;
    private static final byte CODE_SOURCE = 3;
    private static final byte CODE_BIG_INT = 5;
    private static final byte CODE_BOOLEAN_TRUE = 6;
    private static final byte CODE_BOOLEAN_FALSE = 7;

    private SLBytecodeSerialization() {
    }

    public static byte[] serializeNodes(BytecodeParser<SLBytecodeRootNodeGen.Builder> parser) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);
        SLBytecodeRootNodeGen.serialize(outputStream, (context, buffer, object) -> {
            if (object instanceof SLNull) {
                buffer.writeByte(0);
            } else if (object instanceof TruffleString) {
                TruffleString str = (TruffleString)object;
                buffer.writeByte(1);
                SLBytecodeSerialization.writeString(buffer, str);
            } else if (object instanceof Long) {
                buffer.writeByte(2);
                buffer.writeLong((Long)object);
            } else if (object instanceof Boolean) {
                buffer.writeByte((Boolean)object != false ? 6 : 7);
            } else if (object instanceof SLBigInteger) {
                SLBigInteger num = (SLBigInteger)object;
                buffer.writeByte(5);
                SLBytecodeSerialization.writeByteArray(buffer, num.getValue().toByteArray());
            } else if (object instanceof Source) {
                Source s = (Source)object;
                buffer.writeByte(3);
                SLBytecodeSerialization.writeByteArray(buffer, s.getName().getBytes());
            } else {
                throw new UnsupportedOperationException("unsupported constant: " + object.getClass().getSimpleName() + " " + String.valueOf(object));
            }
        }, parser);
        return byteArrayOutputStream.toByteArray();
    }

    static void writeString(DataOutput buffer, TruffleString str) throws IOException {
        SLBytecodeSerialization.writeByteArray(buffer, str.getInternalByteArrayUncached(SLLanguage.STRING_ENCODING).getArray());
    }

    private static byte[] readByteArray(DataInput buffer) throws IOException {
        int len = buffer.readInt();
        byte[] dest = new byte[len];
        buffer.readFully(dest);
        return dest;
    }

    private static void writeByteArray(DataOutput buffer, byte[] data) throws IOException {
        buffer.writeInt(data.length);
        buffer.write(data);
    }

    public static BytecodeRootNodes<SLBytecodeRootNode> deserializeNodes(SLLanguage language, byte[] inputData) throws IOException {
        Supplier<DataInput> input = () -> SerializationUtils.createDataInput((ByteBuffer)ByteBuffer.wrap(inputData));
        return SLBytecodeRootNodeGen.deserialize(language, BytecodeConfig.DEFAULT, input, (context, buffer) -> {
            byte tag = buffer.readByte();
            switch (tag) {
                case 0: {
                    return SLNull.SINGLETON;
                }
                case 1: {
                    return SLBytecodeSerialization.readString(buffer);
                }
                case 2: {
                    return buffer.readLong();
                }
                case 6: {
                    return Boolean.TRUE;
                }
                case 7: {
                    return Boolean.FALSE;
                }
                case 5: {
                    return new SLBigInteger(new BigInteger(SLBytecodeSerialization.readByteArray(buffer)));
                }
                case 3: {
                    String name = new String(SLBytecodeSerialization.readByteArray(buffer));
                    return Source.newBuilder((String)"sl", (CharSequence)"", (String)name).build();
                }
            }
            throw new UnsupportedOperationException("unsupported tag: " + tag);
        });
    }

    static TruffleString readString(DataInput buffer) throws IOException {
        return TruffleString.fromByteArrayUncached((byte[])SLBytecodeSerialization.readByteArray(buffer), (TruffleString.Encoding)SLLanguage.STRING_ENCODING);
    }
}

