/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.bytecode;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.bytecode.TagTreeNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.bytecode.SLBytecodeRootNode;
import com.oracle.truffle.sl.runtime.SLContext;
import com.oracle.truffle.sl.runtime.SLNull;
import com.oracle.truffle.sl.runtime.SLStrings;
import java.util.LinkedHashMap;
import java.util.Map;

@ExportLibrary(value=NodeLibrary.class, receiverType=TagTreeNode.class)
final class SLBytecodeScopeExports {
    SLBytecodeScopeExports() {
    }

    @ExportMessage
    static boolean hasRootInstance(TagTreeNode node, Frame frame, @Bind SLContext context) {
        return SLBytecodeScopeExports.getRootInstanceSlowPath(context, node) != null;
    }

    @ExportMessage
    static Object getRootInstance(TagTreeNode node, Frame frame, @Bind SLContext context) throws UnsupportedMessageException {
        return SLBytecodeScopeExports.getRootInstanceSlowPath(context, node);
    }

    @CompilerDirectives.TruffleBoundary
    private static Object getRootInstanceSlowPath(SLContext context, TagTreeNode node) {
        return context.getFunctionRegistry().getFunction(SLStrings.getSLRootName(node.getRootNode()));
    }

    @ExportMessage
    static boolean hasScope(TagTreeNode node, Frame frame) {
        return true;
    }

    @ExportMessage
    static Object getScope(TagTreeNode node, Frame frame, boolean nodeEnter) throws UnsupportedMessageException {
        if (node.hasTag(StandardTags.RootTag.class)) {
            return new ArgumentsScope(node, frame);
        }
        return node.createDefaultScope(frame, nodeEnter);
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class ArgumentsScope
    implements TruffleObject {
        @NeverDefault
        final SLBytecodeRootNode rootNode;
        final Frame frame;
        private Map<String, Integer> nameToIndex;

        private ArgumentsScope(TagTreeNode node, Frame frame) {
            this.rootNode = (SLBytecodeRootNode)node.getBytecodeNode().getBytecodeRootNode();
            this.frame = frame;
        }

        @ExportMessage
        boolean hasLanguage() {
            return true;
        }

        @ExportMessage
        Class<? extends TruffleLanguage<?>> getLanguage() {
            return SLLanguage.class;
        }

        @ExportMessage
        boolean accepts(@Cached(value="this.rootNode", adopt=false) SLBytecodeRootNode cachedRootNode) {
            return this.rootNode == cachedRootNode;
        }

        @ExportMessage
        boolean isScope() {
            return true;
        }

        @ExportMessage
        boolean hasMembers() {
            return true;
        }

        @ExportMessage
        Object getMembers(boolean includeInternal) {
            return new Members(this.rootNode.getArgumentNames());
        }

        @ExportMessage
        boolean isMemberInsertable(String member) {
            return false;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean hasSourceLocation() {
            return this.rootNode.ensureSourceSection() != null;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        SourceSection getSourceLocation() throws UnsupportedMessageException {
            SourceSection section = this.rootNode.ensureSourceSection();
            if (section == null) {
                throw UnsupportedMessageException.create();
            }
            return section;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object toDisplayString(boolean allowSideEffects) {
            return this.rootNode.getName();
        }

        public String toString() {
            return "Scope[" + String.valueOf(this.getNameToIndex()) + "]";
        }

        @CompilerDirectives.TruffleBoundary
        int slotToIndex(String member) {
            Map<String, Integer> locals = this.getNameToIndex();
            Integer index = locals.get(member);
            if (index == null) {
                return -1;
            }
            return index;
        }

        private Map<String, Integer> getNameToIndex() {
            Map<String, Integer> names = this.nameToIndex;
            if (names == null) {
                this.nameToIndex = names = this.createNameToIndex();
            }
            return names;
        }

        private Map<String, Integer> createNameToIndex() {
            Object[] names;
            LinkedHashMap<String, Integer> locals = new LinkedHashMap<String, Integer>();
            int index = 0;
            for (Object local : names = this.rootNode.getArgumentNames()) {
                String name = this.resolveLocalName(local);
                locals.put(name, index);
                ++index;
            }
            return locals;
        }

        private String resolveLocalName(Object local) {
            String name = null;
            if (local != null) {
                try {
                    name = InteropLibrary.getUncached().asString(local);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
            return name;
        }

        private Members createMembers() {
            return new Members(this.rootNode.getArgumentNames());
        }

        @CompilerDirectives.TruffleBoundary
        static boolean equalsString(String a, String b) {
            return a.equals(b);
        }

        @ExportMessage
        static class WriteMember {
            WriteMember() {
            }

            @Specialization(guards={"equalsString(cachedMember, member)"}, limit="5")
            static void doCached(ArgumentsScope scope, String member, Object value, @Cached(value="member") String cachedMember, @Cached(value="scope.slotToIndex(cachedMember)") int index) throws UnknownIdentifierException, UnsupportedMessageException {
                if (index == -1 || scope.frame == null) {
                    throw UnsupportedMessageException.create();
                }
                Object[] arguments = scope.frame.getArguments();
                if (index >= arguments.length) {
                    throw UnsupportedMessageException.create();
                }
                arguments[index] = value;
            }

            @Specialization(replaces={"doCached"})
            @CompilerDirectives.TruffleBoundary
            static void doGeneric(ArgumentsScope scope, String member, Object value) throws UnknownIdentifierException, UnsupportedMessageException {
                WriteMember.doCached(scope, member, value, member, scope.slotToIndex(member));
            }
        }

        @ExportMessage
        static class IsMemberModifiable {
            IsMemberModifiable() {
            }

            @Specialization(guards={"equalsString(cachedMember, member)"}, limit="5")
            static boolean doCached(ArgumentsScope scope, String member, @Cached(value="member") String cachedMember, @Cached(value="scope.slotToIndex(cachedMember)") int index) {
                return index != -1 && scope.frame != null && index < scope.frame.getArguments().length;
            }

            @Specialization(replaces={"doCached"})
            static boolean doGeneric(ArgumentsScope scope, String member) {
                return IsMemberModifiable.doCached(scope, member, member, scope.slotToIndex(member));
            }
        }

        @ExportMessage
        static class IsMemberReadable {
            IsMemberReadable() {
            }

            @Specialization(guards={"equalsString(cachedMember, member)"}, limit="5")
            static boolean doCached(ArgumentsScope scope, String member, @Cached(value="member") String cachedMember, @Cached(value="scope.slotToIndex(cachedMember)") int index) {
                return index != -1;
            }

            @Specialization(replaces={"doCached"})
            static boolean doGeneric(ArgumentsScope scope, String member) {
                return scope.slotToIndex(member) != -1;
            }
        }

        @ExportMessage
        static class ReadMember {
            ReadMember() {
            }

            @Specialization(guards={"equalsString(cachedMember, member)"}, limit="5")
            static Object doCached(ArgumentsScope scope, String member, @Cached(value="member") String cachedMember, @Cached(value="scope.slotToIndex(cachedMember)") int index) throws UnsupportedMessageException {
                Object[] arguments;
                if (index == -1) {
                    throw UnsupportedMessageException.create();
                }
                Frame frame = scope.frame;
                Object[] objectArray = arguments = frame != null ? scope.frame.getArguments() : null;
                if (arguments == null || index >= arguments.length) {
                    return SLNull.SINGLETON;
                }
                return arguments[index];
            }

            @Specialization(replaces={"doCached"})
            static Object doGeneric(ArgumentsScope scope, String member) throws UnsupportedMessageException {
                return ReadMember.doCached(scope, member, member, scope.slotToIndex(member));
            }
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class Members
    implements TruffleObject {
        final Object[] argumentNames;

        Members(Object[] argumentNames) {
            this.argumentNames = argumentNames;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.argumentNames.length;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            long size = this.getArraySize();
            if (index < 0L || index >= size) {
                throw InvalidArrayIndexException.create((long)index);
            }
            return this.argumentNames[(int)index];
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return index >= 0L && index < this.getArraySize();
        }
    }
}

