/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.sl.bytecode;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.bytecode.BytecodeNode;
import com.oracle.truffle.api.bytecode.BytecodeRootNode;
import com.oracle.truffle.api.bytecode.LocalVariable;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.sl.SLException;
import com.oracle.truffle.sl.SLLanguage;
import com.oracle.truffle.sl.builtins.SLBuiltinNode;
import com.oracle.truffle.sl.nodes.SLExpressionNode;
import com.oracle.truffle.sl.nodes.SLRootNode;
import com.oracle.truffle.sl.nodes.SLTypes;
import com.oracle.truffle.sl.runtime.SLFunction;
import com.oracle.truffle.sl.runtime.SLNull;

@TypeSystemReference(value=SLTypes.class)
public abstract class SLBytecodeRootNode
extends SLRootNode
implements BytecodeRootNode {
    protected TruffleString tsName;
    protected int parameterCount;

    protected SLBytecodeRootNode(SLLanguage language, FrameDescriptor frameDescriptor) {
        super(language, frameDescriptor);
    }

    @Override
    public SLExpressionNode getBodyNode() {
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public final Object[] getArgumentNames() {
        Object[] names = new Object[this.parameterCount];
        int index = 0;
        for (LocalVariable var : this.getBytecodeNode().getLocals().subList(0, this.parameterCount)) {
            names[index++] = var.getName();
        }
        return names;
    }

    public void setParameterCount(int localCount) {
        this.parameterCount = localCount;
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    @Override
    public TruffleString getTSName() {
        return this.tsName;
    }

    public void setTSName(TruffleString tsName) {
        this.tsName = tsName;
    }

    @Override
    public void setLocalValues(FrameInstance frame, Object[] args) {
        BytecodeNode.setLocalValues((FrameInstance)frame, (Object[])args);
    }

    @Override
    public final Object[] getLocalNames(FrameInstance frame) {
        return BytecodeNode.getLocalNames((FrameInstance)frame);
    }

    @Override
    public final Object[] getLocalValues(FrameInstance frame) {
        return BytecodeNode.getLocalValues((FrameInstance)frame);
    }

    protected Object translateStackTraceElement(TruffleStackTraceElement element) {
        return super.translateStackTraceElement(element);
    }

    @Override
    public final SourceSection ensureSourceSection() {
        return super.ensureSourceSection();
    }

    public static final class SLInvoke {
        @Specialization(limit="3", guards={"function.getCallTarget() == cachedTarget"}, assumptions={"callTargetStable"})
        protected static Object doDirect(SLFunction function, Object[] arguments, @Cached(value="function.getCallTargetStable()") Assumption callTargetStable, @Cached(value="function.getCallTarget()") RootCallTarget cachedTarget, @Cached(value="create(cachedTarget)") DirectCallNode callNode) {
            Object returnValue = callNode.call(arguments);
            return returnValue;
        }

        @Specialization(replaces={"doDirect"})
        protected static Object doIndirect(SLFunction function, Object[] arguments, @Cached IndirectCallNode callNode) {
            return callNode.call((CallTarget)function.getCallTarget(), arguments);
        }

        @Specialization
        protected static Object doInterop(Object function, Object[] arguments, @CachedLibrary(limit="3") InteropLibrary library, @Bind Node location) {
            try {
                return library.execute(function, arguments);
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw SLException.undefinedFunction(location, function);
            }
        }
    }

    public static final class Builtin {
        @Specialization(guards={"arguments.length == argumentCount"})
        static Object doInBounds(VirtualFrame frame, NodeFactory<?> factory, int argumentCount, @Bind Node bytecode, @Bind(value="frame.getArguments()") Object[] arguments, @Cached.Shared @Cached(value="createBuiltin(factory)", uncached="getUncachedBuiltin()", neverDefault=true) SLBuiltinNode builtin) {
            return Builtin.doInvoke(frame, bytecode, builtin, arguments);
        }

        @ExplodeLoop
        @Fallback
        static Object doOutOfBounds(VirtualFrame frame, NodeFactory<?> factory, int argumentCount, @Bind Node bytecode, @Cached.Shared @Cached(value="createBuiltin(factory)", uncached="getUncachedBuiltin()", neverDefault=true) SLBuiltinNode builtin) {
            Object[] originalArguments = frame.getArguments();
            Object[] arguments = new Object[argumentCount];
            for (int i = 0; i < argumentCount; ++i) {
                arguments[i] = i < originalArguments.length ? originalArguments[i] : SLNull.SINGLETON;
            }
            return Builtin.doInvoke(frame, bytecode, builtin, arguments);
        }

        static SLBuiltinNode createBuiltin(NodeFactory<?> factory) {
            return (SLBuiltinNode)((Object)factory.createNode(new Object[0]));
        }

        static SLBuiltinNode getUncachedBuiltin() {
            throw CompilerDirectives.shouldNotReachHere((String)"Builtins should not execute uncached.");
        }

        private static Object doInvoke(VirtualFrame frame, Node node, SLBuiltinNode builtin, Object[] arguments) {
            try {
                if (builtin.getParent() == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    node.insert((Node)builtin);
                }
                return builtin.execute(frame, arguments);
            }
            catch (UnsupportedSpecializationException e) {
                throw SLException.typeError(e.getNode(), e.getSuppliedValues());
            }
        }
    }

    public static final class SLLoadArgument {
        @Specialization(guards={"index < arguments.length"})
        static Object doLoadInBounds(VirtualFrame frame, int index, @Bind(value="frame.getArguments()") Object[] arguments) {
            return arguments[index];
        }

        @Fallback
        static Object doLoadOutOfBounds(int index) {
            return SLNull.SINGLETON;
        }
    }

    public static final class SLAlwaysHalt {
        @Specialization
        static void doDefault() {
        }
    }
}

